/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.datastructures;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.Require;
import com.github.kilianB.datastructures.ClusterResult;
import com.github.kilianB.hash.FuzzyHash;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.pcg.fast.PcgRSFast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Logger;

public class KMeans {
    private static final Logger LOGGER = Logger.getLogger(KMeans.class.getSimpleName());
    protected int k;

    public KMeans(int clusters) {
        this.k = (Integer)Require.positiveValue((Number)clusters);
    }

    public ClusterResult cluster(Hash[] hashes) {
        return this.cluster(hashes, Integer.MAX_VALUE);
    }

    public ClusterResult cluster(Hash[] hashes, int maxIter) {
        int[] cluster = new int[hashes.length];
        if (this.k == 1) {
            return new ClusterResult(cluster, hashes);
        }
        if (this.k > hashes.length) {
            ArrayUtil.fillArray((int[])cluster, i -> i);
            LOGGER.info("Not enough images present for k categories. Assume: " + hashes.length + " cluster/s");
            return new ClusterResult(cluster, hashes);
        }
        FuzzyHash[] clusterMeans = this.computeStartingClusters(hashes);
        System.out.println("starting cluster");
        this.computeKMeans(cluster, clusterMeans, hashes, maxIter);
        return new ClusterResult(cluster, hashes);
    }

    protected FuzzyHash[] computeStartingClusters(Hash[] hashes) {
        PcgRSFast rng = new PcgRSFast();
        ArrayList<Integer> randomIndices = new ArrayList<Integer>(this.k);
        for (int i = 0; i < hashes.length; ++i) {
            randomIndices.add(i);
        }
        Collections.shuffle(randomIndices, (Random)rng);
        FuzzyHash[] startingClusters = new FuzzyHash[this.k];
        System.out.println(randomIndices);
        for (int i = 0; i < this.k; ++i) {
            startingClusters[i] = new FuzzyHash();
            startingClusters[i].mergeFast(hashes[(Integer)randomIndices.remove(0)]);
        }
        return startingClusters;
    }

    protected void computeKMeans(int[] cluster, FuzzyHash[] clusterMeans, Hash[] hashes, int maxIter) {
        int iter = 0;
        boolean dirty = false;
        do {
            dirty = false;
            for (int dataIndex = 0; dataIndex < hashes.length; ++dataIndex) {
                double minDistance = Double.MAX_VALUE;
                int bestCluster = -1;
                for (int clusterIndex = 0; clusterIndex < clusterMeans.length; ++clusterIndex) {
                    double distToCluster = clusterMeans[clusterIndex].normalizedHammingDistanceFast(hashes[dataIndex]);
                    if (!(distToCluster < minDistance)) continue;
                    bestCluster = clusterIndex;
                    minDistance = distToCluster;
                }
                if (cluster[dataIndex] == bestCluster) continue;
                cluster[dataIndex] = bestCluster;
                dirty = true;
            }
            if (!dirty) continue;
            Hash[] clones = new Hash[clusterMeans.length];
            int i = 0;
            for (FuzzyHash fuzzy : clusterMeans) {
                fuzzy.reset();
                clones[i++] = new Hash(fuzzy.getHashValue(), fuzzy.getBitResolution(), fuzzy.getAlgorithmId());
            }
            for (int dataIndex = 0; dataIndex < hashes.length; ++dataIndex) {
                int clusterIndex = cluster[dataIndex];
                clusterMeans[clusterIndex].mergeFast(hashes[dataIndex]);
            }
            for (int j = 0; j < clones.length; ++j) {
                clusterMeans[j].subtractFast(clones[j]);
            }
        } while (iter++ <= maxIter && dirty);
    }
}

