/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.benchmark;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.MathUtil;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.TypedImageMatcher;
import com.github.kilianB.matcher.categorize.supervised.LabeledImage;
import com.github.kilianB.matcher.exotic.SingleImageMatcher;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class AlgorithmBenchmarker {
    private static final Logger LOGGER = Logger.getLogger(AlgorithmBenchmarker.class.getName());
    private static String htmlBase = AlgorithmBenchmarker.buildHtmlBase();
    private DecimalFormat df = new DecimalFormat("0.000");
    private boolean timming;
    private int buckets;
    private boolean stepped;
    private SingleImageMatcher imageMatcher;
    private List<LabeledImage> imagesToTest = new ArrayList<LabeledImage>();
    private Map<HashingAlgorithm, TypedImageMatcher.AlgoSettings> algorithmsToTest;

    public AlgorithmBenchmarker(SingleImageMatcher imageMatcher, boolean speedBenchmark) {
        this.timming = speedBenchmark;
        this.imageMatcher = imageMatcher;
        this.buckets = 10;
        this.stepped = true;
    }

    public AlgorithmBenchmarker(SingleImageMatcher imageMatcher, boolean speedBenchmark, int bucket, boolean stepped) {
        this.timming = speedBenchmark;
        this.imageMatcher = imageMatcher;
        this.buckets = bucket;
        this.stepped = stepped;
    }

    public void addTestImages(LabeledImage ... testImages) {
        for (LabeledImage t : testImages) {
            this.imagesToTest.add(t);
        }
    }

    public void toConsole() {
        System.out.println(this.constructHTML(true));
    }

    public void toFile() {
        this.toFile(new File("Benchmark_" + System.currentTimeMillis() + ".html"));
    }

    public void toFile(File outputFile) {
        String output = this.constructHTML(true);
        try (FileWriter fw = new FileWriter(outputFile);){
            fw.write(output);
            LOGGER.info("HTML File Created: " + outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.severe("Can't create benchmark file: " + e.getCause());
            System.out.println(output);
        }
    }

    public void display() {
        String html = this.constructHTML(false);
        new Thread(() -> {
            try {
                Application.launch(BenchmarkApplication.class, (String[])new String[]{html});
            }
            catch (IllegalStateException state) {
                new BenchmarkApplication().spawnWindow(html);
            }
        }, "Display Algorithm Benchmark").start();
    }

    protected String constructHTML(boolean initChart) {
        Collections.sort(this.imagesToTest);
        HashMap<HashingAlgorithm, DoubleSummaryStatistics[]> statMap = new HashMap<HashingAlgorithm, DoubleSummaryStatistics[]>();
        this.algorithmsToTest = this.imageMatcher.getAlgorithms();
        HashMap<HashingAlgorithm, List<Double>[]> scatterMap = new HashMap<HashingAlgorithm, List<Double>[]>();
        for (HashingAlgorithm hashingAlgorithm : this.algorithmsToTest.keySet()) {
            DoubleSummaryStatistics[] stats = new DoubleSummaryStatistics[6];
            ArrayUtil.fillArrayMulti((Object)stats, () -> new DoubleSummaryStatistics());
            statMap.put(hashingAlgorithm, stats);
            if (!initChart) continue;
            List[] l = new List[]{new ArrayList(), new ArrayList()};
            scatterMap.put(hashingAlgorithm, l);
        }
        HashMap<HashingAlgorithm, Map<LabeledImage, Hash>> hashes = new HashMap<HashingAlgorithm, Map<LabeledImage, Hash>>();
        for (HashingAlgorithm h : this.algorithmsToTest.keySet()) {
            HashMap<LabeledImage, Hash> algorithmSpecificHash = new HashMap<LabeledImage, Hash>();
            hashes.put(h, algorithmSpecificHash);
            for (LabeledImage t : this.imagesToTest) {
                algorithmSpecificHash.put(t, h.hash(t.getbImage()));
            }
        }
        StringBuilderI stringBuilderI = new StringBuilderI();
        stringBuilderI.row("<div>");
        this.appendHeader(stringBuilderI);
        this.appendAlgorithmInformation(stringBuilderI);
        this.appendHashingDistances(stringBuilderI, hashes, statMap, scatterMap, initChart);
        this.appendStatistics(stringBuilderI, statMap);
        if (this.timming) {
            this.appendTimmingBenchmark(stringBuilderI);
        }
        stringBuilderI.append("</tbody></table>");
        if (initChart) {
            this.appendChartSection(stringBuilderI, scatterMap, statMap);
        }
        return htmlBase.replace("$body", stringBuilderI.append("</div>").toString());
    }

    protected void appendHeader(StringBuilderI htmlBuilder) {
        htmlBuilder.append("<table id='rootTable'>\n").append("<thead><tr> <th>Images</th> <th>Category</th> <th colspan=" + this.algorithmsToTest.size() + ">Distance</th> </tr></thead>\n").append("<tbody><tr><td colspan = 2></td>");
        for (HashingAlgorithm h : this.algorithmsToTest.keySet()) {
            htmlBuilder.append("<td id='" + h.algorithmId() + "'>" + h.toString() + "</td>");
        }
        htmlBuilder.append("</tr>\n");
    }

    protected void appendAlgorithmInformation(StringBuilderI htmlBuilder) {
        htmlBuilder.append("<tr><td colspan = 2><b>Actual Resolution:</b></td>");
        for (HashingAlgorithm h : this.algorithmsToTest.keySet()) {
            htmlBuilder.append("<td>").append(h.getKeyResolution()).append("bits</td>");
        }
        htmlBuilder.append("</tr>\n");
        htmlBuilder.append("<tr><td colspan = 2><b>Threshold:</b></td>");
        for (HashingAlgorithm h : this.algorithmsToTest.keySet()) {
            htmlBuilder.append("<td>").append(this.df.format(this.algorithmsToTest.get(h).getThreshold())).append("</td>");
        }
        htmlBuilder.append("</tr>\n");
        this.emptyTableRow(htmlBuilder);
    }

    protected void appendHashingDistances(StringBuilderI htmlBuilder, Map<HashingAlgorithm, Map<LabeledImage, Hash>> hashes, Map<HashingAlgorithm, DoubleSummaryStatistics[]> statMap, Map<HashingAlgorithm, List<Double>[]> scatterMap, boolean initChart) {
        int lastCategory = 0;
        ArrayList<LabeledImage> sortedKeys = new ArrayList<LabeledImage>(this.imagesToTest);
        for (LabeledImage base : this.imagesToTest) {
            sortedKeys.remove(base);
            if (base.getCategory() != lastCategory) {
                lastCategory = base.getCategory();
                this.emptyTableRow(htmlBuilder);
            }
            for (LabeledImage cross : sortedKeys) {
                htmlBuilder.append("<tr>");
                boolean first = true;
                for (Map.Entry<HashingAlgorithm, TypedImageMatcher.AlgoSettings> entry : this.algorithmsToTest.entrySet()) {
                    HashingAlgorithm h = entry.getKey();
                    TypedImageMatcher.AlgoSettings algoSettings = entry.getValue();
                    boolean supposedToMatch = base.getCategory() == cross.getCategory();
                    Hash baseHash = hashes.get(h).get(base);
                    Hash crossHash = hashes.get(h).get(cross);
                    double distance = algoSettings.isNormalized() ? baseHash.normalizedHammingDistance(crossHash) : (double)baseHash.hammingDistance(crossHash);
                    if (initChart) {
                        scatterMap.get(h)[supposedToMatch ? 0 : 1].add(distance);
                    }
                    boolean consideredMatch = algoSettings.getThreshold() >= distance;
                    String backgroundColor = "";
                    if (consideredMatch) {
                        if (supposedToMatch) {
                            statMap.get(h)[2].accept(1.0);
                        } else {
                            statMap.get(h)[3].accept(1.0);
                            backgroundColor = "fault";
                        }
                    } else if (supposedToMatch) {
                        statMap.get(h)[4].accept(1.0);
                        backgroundColor = "fault";
                    } else {
                        statMap.get(h)[5].accept(1.0);
                    }
                    if (first) {
                        htmlBuilder.append("<td>").append(base.getName()).append("-").append(cross.getName()).append("</td><td class='category'>").append("[").append(base.getCategory()).append("-").append(cross.getCategory()).append("]</td>");
                        first = false;
                    }
                    htmlBuilder.append("<td class='").append(backgroundColor).append("'>");
                    if (algoSettings.isNormalized()) {
                        htmlBuilder.append(this.df.format(distance));
                    } else {
                        htmlBuilder.append((int)distance);
                    }
                    htmlBuilder.append("</td>");
                    statMap.get(h)[supposedToMatch ? 0 : 1].accept(distance);
                }
                htmlBuilder.append("</tr>\n");
            }
        }
        this.emptyTableRow(htmlBuilder);
    }

    protected void appendStatistics(StringBuilderI htmlBuilder, Map<HashingAlgorithm, DoubleSummaryStatistics[]> statMap) {
        int numberOfPairs = MathUtil.triangularNumber((int)(this.imagesToTest.size() - 1));
        String[] columnNames = new String[]{"Avg match:", "Avg distinct:", "Min/Max match:", "Min/Max distinct:", "True Positive / False Positive", "", "False Negative / True Negative", "Accuracy", "Precision"};
        for (int i = 0; i < columnNames.length; ++i) {
            htmlBuilder.append("<tr>");
            htmlBuilder.append("<td colspan = 2><b>").append(columnNames[i]).append("</b></td>");
            for (HashingAlgorithm h : this.algorithmsToTest.keySet()) {
                if (i < 2) {
                    htmlBuilder.append("<td>").append(this.df.format(statMap.get(h)[i].getAverage())).append("</td>");
                    continue;
                }
                if (i < 4) {
                    DoubleSummaryStatistics dSum0 = statMap.get(h)[i - 2];
                    if (this.algorithmsToTest.get(h).isNormalized()) {
                        htmlBuilder.append("<td>").append(this.df.format(dSum0.getMin())).append("/").append(this.df.format(dSum0.getMax())).append("</td>");
                        continue;
                    }
                    htmlBuilder.append("<td>").append((int)dSum0.getMin()).append("/").append((int)dSum0.getMax()).append("</td>");
                    continue;
                }
                if (i < 7) {
                    DoubleSummaryStatistics dSum0 = statMap.get(h)[i - 2];
                    DoubleSummaryStatistics dSum1 = statMap.get(h)[i - 1];
                    htmlBuilder.append("<td>").append(dSum0.getCount()).append("/").append(dSum1.getCount()).append("</td>");
                    continue;
                }
                if (i == 7) {
                    int truePositive = (int)statMap.get(h)[2].getCount();
                    int trueNegative = (int)statMap.get(h)[5].getCount();
                    htmlBuilder.append("<td>").append(this.df.format((double)(truePositive + trueNegative) / (double)numberOfPairs)).append("</td>");
                    continue;
                }
                if (i != 8) continue;
                int truePositive = (int)statMap.get(h)[2].getCount();
                int falsePositive = (int)statMap.get(h)[3].getCount();
                htmlBuilder.append("<td>");
                if (truePositive > 0 || falsePositive > 0) {
                    htmlBuilder.append(this.df.format((double)truePositive / (double)(truePositive + falsePositive)));
                } else {
                    htmlBuilder.append("-");
                }
                htmlBuilder.append("</td>");
            }
            if (i == 4) {
                ++i;
            }
            htmlBuilder.append("</tr>\n");
        }
    }

    private void emptyTableRow(StringBuilderI builder) {
        builder.append("<tr class='spacerRow'><td colspan='2'></td><td colspan='").append(this.algorithmsToTest.size()).row("'></td></tr>");
    }

    protected long appendTimmingBenchmark(StringBuilderI htmlBuilder) {
        long sum = 0L;
        HashMap<HashingAlgorithm, Double> averageRuntime = new HashMap<HashingAlgorithm, Double>(this.algorithmsToTest.size());
        HashMap<HashingAlgorithm, Integer> actualLoops = new HashMap<HashingAlgorithm, Integer>();
        for (HashingAlgorithm hasher : this.algorithmsToTest.keySet()) {
            actualLoops.put(hasher, 0);
        }
        sum += this.performWarmup();
        sum += this.performBenchmark(averageRuntime, actualLoops);
        for (HashingAlgorithm hasher : this.algorithmsToTest.keySet()) {
            double avg = (Double)averageRuntime.get(hasher) / (double)((Integer)actualLoops.get(hasher)).intValue();
            averageRuntime.put(hasher, avg);
        }
        htmlBuilder.append("<tr><td colspan=2><b>Timming</b> (ms/picture): *</td>");
        for (HashingAlgorithm hasher : this.algorithmsToTest.keySet()) {
            htmlBuilder.append("<td>").append(this.df.format(averageRuntime.get(hasher)) + " ms").append("</td>");
        }
        htmlBuilder.append("</tr>");
        htmlBuilder.append("<tfoot><tr><td  style='text-align:center;' colspan =").append(this.algorithmsToTest.size() + 2).append(">").append("* Please note that speed benchmarks are not representative and should only be used to get a rough estimated of the magnitude of the speed.").append("</td></tr></tfoot>");
        return sum;
    }

    private long performWarmup() {
        long warmUpCutoff = 5000000000L;
        long sum = 0L;
        for (HashingAlgorithm hasher : this.algorithmsToTest.keySet()) {
            long start = System.nanoTime();
            for (int i = 0; i < 100; ++i) {
                for (LabeledImage testData : this.imagesToTest) {
                    sum += (long)hasher.hash(testData.getbImage()).getHashValue().bitCount();
                }
                if (System.nanoTime() - start <= warmUpCutoff) continue;
                LOGGER.info("warmup cutoff surpassed.");
                return sum;
            }
        }
        return sum;
    }

    private long performBenchmark(Map<HashingAlgorithm, Double> averageRuntime, Map<HashingAlgorithm, Integer> actualLoops) {
        int loops = 500;
        long testCutoff = 60000000000L;
        long start = System.nanoTime();
        long sum = 0L;
        for (int i = 0; i < loops; ++i) {
            for (HashingAlgorithm hasher : this.algorithmsToTest.keySet()) {
                long startIndividual = System.nanoTime();
                for (LabeledImage testData : this.imagesToTest) {
                    sum += (long)hasher.hash(testData.getbImage()).getHashValue().bitCount();
                }
                double elapsed = (double)(System.nanoTime() - startIndividual) / 1000000.0 / (double)this.imagesToTest.size();
                averageRuntime.merge(hasher, elapsed, (old, newVal) -> old + newVal);
                actualLoops.merge(hasher, 1, (old, newVal) -> old + newVal);
                if (System.nanoTime() - start <= testCutoff) continue;
                LOGGER.info("test cutoff surpassed. finish with: " + i + " loops executed");
                return sum;
            }
        }
        return sum;
    }

    protected void appendChartSection(StringBuilderI htmlBuilder, Map<HashingAlgorithm, List<Double>[]> scatterMap, Map<HashingAlgorithm, DoubleSummaryStatistics[]> statMap) {
        boolean success = false;
        URL jScript = AlgorithmBenchmarker.class.getClassLoader().getResource("Chart.bundle.min.js");
        if (jScript != null) {
            File javascriptScript = new File(jScript.getFile());
            htmlBuilder.append("<script src=\"").append(javascriptScript.getAbsolutePath()).append("\"></script>");
            success = true;
        } else {
            LOGGER.info("Could not find js file. fallback to cdn");
            try {
                String cdn = "https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.3/Chart.bundle.min.js";
                HttpURLConnection connection = (HttpURLConnection)new URL(cdn).openConnection();
                connection.setRequestMethod("HEAD");
                if (connection.getResponseCode() == 200) {
                    success = true;
                    htmlBuilder.append("<script src=\"").append(cdn).append("\"/></script>");
                }
            }
            catch (IOException cdn) {
                // empty catch block
            }
        }
        if (success) {
            StringBuilderI positiveDatBuilder = new StringBuilderI();
            StringBuilderI negativeDatBuilder = new StringBuilderI();
            StringBuilderI scatterDatBuilder = new StringBuilderI();
            StringBuilderI centeroidBuilder = new StringBuilderI();
            positiveDatBuilder.row("var dataDictMatch = {};");
            negativeDatBuilder.row("var dataDictDistinct = {};");
            scatterDatBuilder.row("var dataDictScatter = {};");
            centeroidBuilder.row("var dataDictCenter = {};");
            for (Map.Entry<HashingAlgorithm, List<Double>[]> e : scatterMap.entrySet()) {
                int i;
                int i2;
                HashingAlgorithm hasher = e.getKey();
                List<Double>[] occurances = e.getValue();
                double[][] data = new double[occurances[0].size() + occurances[1].size()][1];
                for (i2 = 0; i2 < occurances[0].size(); ++i2) {
                    data[i2][0] = occurances[0].get(i2);
                }
                for (i2 = 0; i2 < occurances[1].size(); ++i2) {
                    data[i2 + occurances[0].size()][0] = occurances[1].get(i2);
                }
                int[] matchBucket = new int[this.buckets];
                int[] distinctBucket = new int[this.buckets];
                double avg = (statMap.get(hasher)[0].getAverage() + statMap.get(hasher)[1].getAverage()) / 2.0;
                scatterDatBuilder.append("dataDictScatter['").append(hasher.algorithmId()).append("']=[");
                centeroidBuilder.append("dataDictCenter['").append(hasher.algorithmId()).append("']=[").append(avg).row("];");
                int dataPoints = occurances[0].size();
                for (i = 0; i < dataPoints; ++i) {
                    int n = (int)(occurances[0].get(i) * (double)this.buckets) + (this.stepped ? 0 : 1);
                    matchBucket[n] = matchBucket[n] + 1;
                    scatterDatBuilder.append("{x:").append(occurances[0].get(i)).append(",y:").append((double)i / 2.0).append("},");
                }
                dataPoints = occurances[1].size();
                if (dataPoints > 0) {
                    scatterDatBuilder.append(",");
                }
                for (i = 0; i < dataPoints; ++i) {
                    int n = (int)(occurances[1].get(i) * (double)this.buckets) + (this.stepped ? 0 : 1);
                    distinctBucket[n] = distinctBucket[n] + 1;
                    scatterDatBuilder.append("{x:").append(occurances[1].get(i)).append(",y:").append((double)i / 2.0).append("}");
                    if (i == dataPoints - 1) continue;
                    scatterDatBuilder.append(",");
                }
                scatterDatBuilder.append("];\n");
                positiveDatBuilder.append("dataDictMatch['").append(hasher.algorithmId()).append("']=[");
                negativeDatBuilder.append("dataDictDistinct['").append(hasher.algorithmId()).append("']=[");
                for (i = 0; i < this.buckets; ++i) {
                    positiveDatBuilder.append("{x:").append((double)i / (double)this.buckets).append(",y:").append(matchBucket[i]).append("}");
                    negativeDatBuilder.append("{x:").append((double)i / (double)this.buckets).append(",y:").append(distinctBucket[i]).append("}");
                    if (i == this.buckets - 1) continue;
                    positiveDatBuilder.append(",");
                    negativeDatBuilder.append(",");
                }
                positiveDatBuilder.row("];");
                negativeDatBuilder.row("];");
            }
            htmlBuilder.row("<div style='width:40%; margin:auto;'>").row("<canvas id ='chartCanvas' width='600' height='400' style='background-color:' />").row("</div>");
            htmlBuilder.row("<script>").append(positiveDatBuilder.toString()).append(negativeDatBuilder.toString()).append(scatterDatBuilder.toString()).append(centeroidBuilder.toString()).row(" Chart.defaults.global.defaultFontColor='white';").row("var canvas = document.getElementById('chartCanvas').getContext('2d')").row("var chart = new Chart(canvas, {").row("\tdata: {\n").row("\t\tdatasets: [{\n").row("\t\t\t\tlabel: 'points',").row("\t\t\t\ttype: 'scatter',").row("\t\t\t\tfill: false,").row("\t\t\t\tshowLine: false,").row("\t\t\t\tpointRadius: 5,").row("\t\t\t\tbackgroundColor: 'orange'").row("\t\t\t},").row("\t\t\t{").row("\t\t\t\ttype: 'line',").row("\t\t\t\tlabel: 'match',").row("\t\t\t\tsteppedLine: " + this.stepped + ",").row("\t\t\t\tpointRadius: 0,").row("\t\t\t\tbackgroundColor: 'rgba(32,178,170,0.65)'").row("\t\t\t\t},").row("\t\t\t{").row("\t\t\t\ttype: 'line',").row("\t\t\t\tlabel: 'distinct',").row("\t\t\t\tsteppedLine: " + this.stepped + ",").row("\t\t\t\tpointRadius: 0,").row("\t\t\t\tbackgroundColor: 'rgba(250,128,114,0.8)'").row("\t\t\t}").row("\t\t]").row("\t},").row("\toptions: {").row("\t\tresponsive: true,").row("\t\tscales: {").row("\t\t\t\tyAxes: [{").row("\t\t\t\t\tgridLines: {").row("\t\t\t\t\t\tcolor: 'white'").row("\t\t\t\t\t},").row("\t\t\t\t\tscaleLabel: {").row("\t\t\t\t\t\tdisplay: true,").row("\t\t\t\t\t\tlabelString: 'Occurances',").row("\t\t\t\t\t}").row("\t\t\t\t}],").row("\t\t\t\txAxes: [{").row("\t\t\t\t\ttype:'linear',").row("\t\t\t\t\tgridLines: {").row("\t\t\t\t\t\tcolor: 'white'").row("\t\t\t\t\t},").row("\t\t\t\t\tticks: {").row("\t\t\t\t\t\tmin:0,").row("\t\t\t\t\t\tmax:1,").row("\t\t\t\t\t\tstepSize:0.1").row("\t\t\t\t\t},").row("\t\t\t\t\tscaleLabel: {").row("\t\t\t\t\t\tdisplay: true,").row("\t\t\t\t\t\tlabelString: 'Distance',").row("\t\t\t\t\t}").row("\t\t\t\t}]").row("\t\t\t},").row("\t\ttitle:{").row("\t\t\tdisplay:true,").row("\t\t\ttext: 'Test'").row("\t\t}").row("\t}").row("})").row("var table = document.getElementById('rootTable');").row("var lastIndex = -1;").row("var lastObject = undefined;").row("table.addEventListener('mousemove',function(e){").row("\tvar parentTr = e.path[1];").row("\tvar target = e.path[0];").row("\tif(target == lastObject){").row("\t\treturn;").row("\t}").row("\tlastObject = target;").row("\tvar correctCellIndex = 0;").row("\t//Fix: Compute correct cellindex due to colspans").row("\tfor(let cell of parentTr.cells){").row(" \t\tif(cell == target){").row("\t\t\tbreak;").row("\t\t}else{").row("\t\t\tcorrectCellIndex += cell.colSpan;").row("\t\t}").row("\t}").row("\tif(correctCellIndex != lastIndex) {").row("\t\tlastIndex = correctCellIndex;").row("\t\t//First tr in tbody with cellIndex - 1").row("\t\tvar id = table.rows[1].cells[correctCellIndex-1].id").row("\t\tif(id === undefined){").row("\t\t\treturn;").row("\t\t}\n").row("\t\t//Repopulate table\n").row("\t\tchart.options.title.text = table.rows[1].cells[correctCellIndex-1].innerText;\n").row("\t\tchart.data.datasets[1].data = dataDictMatch[id];").row("\t\tchart.data.datasets[2].data = dataDictDistinct[id];").row("\t\tchart.data.datasets[0].data = dataDictScatter[id];").row("\t\tchart.config.verticalMarker = dataDictCenter[id]").row("\t\tchart.update();").row("\t}").row("const verticalLinePlugin = {\r\n  getLinePosition: function (chart, value) {\r\n\t\treturn chart.scales['x-axis-0'].getPixelForValue(value);  },\r\n  renderVerticalLine: function (chartInstance, xValue) {\r\n      const lineLeftOffset = this.getLinePosition(chartInstance, xValue);\r\n      const scale = chartInstance.scales['y-axis-0'];\r\n      const context = chartInstance.chart.ctx;\r\n\r\n      // render vertical line\r\n      context.beginPath();\r\n      context.strokeStyle = 'white';\r\n      context.lineWidth = 2;\n      context.moveTo(lineLeftOffset, scale.top);\r\n      context.lineTo(lineLeftOffset, scale.bottom);\r\n      context.stroke();\r\n\r\n      // write label\r\n  },\r\n\r\n  afterDatasetsDraw: function (chart, easing) {\r\n      if (chart.config.verticalMarker) {\r\n          chart.config.verticalMarker.forEach(xValue => this.renderVerticalLine(chart, xValue));\r\n      }\r\n  }\r\n  };\r\n\r\n  Chart.plugins.register(verticalLinePlugin);").row("});</script>");
        } else {
            LOGGER.warning("Could not link to chartjs library. skip chart generation.");
        }
    }

    private static String buildHtmlBase() {
        StringBuilderI htmlBuilder = new StringBuilderI();
        htmlBuilder.row("<!DOCTYPE html>").row("<html>").row("\t<head>").row("\t\t<title>Algorithm Benchmarking</title>").row("\t\t<style>").row("\t\t\thtml{min-height:100%;}").row("\t\t\tbody{min-height:100%; margin: 0; background: linear-gradient(45deg, #49a09d, #5f2c82); font-family: sans-serif; font-weight: 100; margin-bottom:25px;}").row("\t\t\ttable{margin:auto; border-collapse: collapse; box-shadow: 0 0 20px rgba(0,0,0,0.1); margin-top:40px;}").row("\t\t\tthead th, td:first-child, .category{background-color: #55608f;}").row("\t\t\ttr:nth-child(1) {background-color:#3d54b9;}").row("\t\t\tth,td{padding: 10px;background-color: rgba(255,255,255,0.2);color: #fff;}").row("\t\t\ttbody tr:hover{background-color: rgba(255,255,255,0.3);}").row("\t\t\t.spacerRow td{ padding:7px;}").row("\t\t\t.circle{width:10px; height: 10px; background-color:green; border-radius:50%; display:inline-block; margin-right:5px;}").row("\t\t\t.fault{color:#fff700;}").row("\t\t</style>").row("\t</head>").row("\t<body>").row("\t\t$body").row("\t</body>").row("</html>");
        return htmlBuilder.toString();
    }

    public static class BenchmarkApplication
    extends Application {
        public void start(Stage primaryStage) throws Exception {
            this.spawnNewWindow(primaryStage, (String)this.getParameters().getRaw().get(0));
        }

        public void spawnWindow(String html) {
            Platform.runLater(() -> this.spawnNewWindow(new Stage(), html));
        }

        private void spawnNewWindow(Stage stage, String htmlContent) {
            WebView webView = new WebView();
            webView.getEngine().loadContent(htmlContent);
            Rectangle2D screen = Screen.getPrimary().getVisualBounds();
            double w = screen.getWidth();
            double h = screen.getHeight();
            Scene scene = new Scene((Parent)webView, w, h);
            stage.setTitle("Image Hash Benchmarker");
            stage.getIcons().add((Object)new Image("imageHashLogo.png"));
            stage.setScene(scene);
            stage.show();
        }
    }

    private static class StringBuilderI {
        private StringBuilder internal = new StringBuilder();

        private StringBuilderI() {
        }

        public StringBuilderI append(String s) {
            this.internal.append(s);
            return this;
        }

        public StringBuilderI append(double d) {
            this.internal.append(d);
            return this;
        }

        public StringBuilderI append(long l) {
            this.internal.append(l);
            return this;
        }

        public StringBuilderI append(int i) {
            this.internal.append(i);
            return this;
        }

        public StringBuilderI row(String s) {
            this.internal.append(s).append("\n");
            return this;
        }

        public String toString() {
            return this.internal.toString();
        }
    }
}

