/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.util.randomstring;

import com.github.jsonzou.jmockdata.util.randomstring.Letter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

class RandomLetterPicker {
    private final List<String> letters;
    private final int size;
    private final Random random;

    public static Builder builder() {
        return new Builder();
    }

    private RandomLetterPicker(Builder b) {
        this.letters = Collections.unmodifiableList(b.getLetters());
        this.random = b.getRandom() == null ? new Random() : b.getRandom();
        this.size = this.letters.size();
    }

    public String pickRandomLetter() {
        return this.letters.get(this.random.nextInt(this.size));
    }

    public static RandomLetterPicker constructByCharacterRange(List<String> bounds) {
        Builder definedPickerBuilder = RandomLetterPicker.builder();
        int bufferSize = bounds.size();
        int i = 0;
        while (i < bufferSize) {
            if (i + 2 <= bufferSize && bounds.get(i + 1).length() == 2 && bounds.get(i + 1).charAt(1) == '-') {
                int beginCode = bounds.get(i).charAt(0);
                char endCode = bounds.get(i + 1).charAt(0);
                i += 2;
                if (beginCode > endCode) {
                    throw new RuntimeException("Detected invalid character range: [" + (char)beginCode + "-" + (char)endCode + "]");
                }
                for (int code = beginCode; code <= endCode; ++code) {
                    definedPickerBuilder.add(String.valueOf((char)code));
                }
                continue;
            }
            definedPickerBuilder.add(bounds.get(i++));
        }
        return definedPickerBuilder.build();
    }

    public static class Builder {
        private List<String> letters = new ArrayList<String>();
        private Random random = null;

        public <E extends Enum<E>> Builder addAllByEnum(Class<E> enumClass) {
            Enum[] enumConstants;
            for (Enum e : enumConstants = (Enum[])enumClass.getEnumConstants()) {
                this.letters.add(((Letter)((Object)e)).getLetter());
            }
            return this;
        }

        public Builder addAll(List<String> list) {
            this.letters.addAll(list);
            return this;
        }

        public Builder add(String letter) {
            this.letters.add(letter);
            return this;
        }

        public Builder remove(String remove) {
            Iterator<String> iterator = this.letters.iterator();
            ArrayList<String> tempLetters = new ArrayList<String>(this.letters.size());
            while (iterator.hasNext()) {
                tempLetters.add(iterator.next());
            }
            this.letters = tempLetters;
            return this;
        }

        public Builder setRandom(Random random) {
            this.random = random;
            return this;
        }

        public RandomLetterPicker build() {
            return new RandomLetterPicker(this);
        }

        public List<String> getLetters() {
            return this.letters;
        }

        public Random getRandom() {
            return this.random;
        }
    }
}

