/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.parser.standard;

import com.rtfparserkit.parser.standard.CommandEvent;
import com.rtfparserkit.parser.standard.IParserEvent;
import com.rtfparserkit.parser.standard.IParserEventHandler;
import com.rtfparserkit.parser.standard.ParserEventType;
import com.rtfparserkit.rtf.Command;
import java.util.ArrayList;
import java.util.List;

public class UprHandler
implements IParserEventHandler {
    private final IParserEventHandler handler;
    private int groupCount = 1;
    private boolean complete;
    private final List<IParserEvent> events = new ArrayList<IParserEvent>();

    public UprHandler(IParserEventHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleEvent(IParserEvent event) {
        this.events.add(event);
        switch (event.getType()) {
            case GROUP_START_EVENT: {
                ++this.groupCount;
                break;
            }
            case GROUP_END_EVENT: {
                --this.groupCount;
                break;
            }
        }
        if (this.groupCount == 0) {
            this.processCommands();
        }
    }

    @Override
    public IParserEvent getLastEvent() {
        return this.events.get(this.events.size() - 1);
    }

    @Override
    public void removeLastEvent() {
        this.events.remove(this.events.size() - 1);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    private void processCommands() {
        int endIndex;
        int index = 0;
        while (true) {
            CommandEvent command;
            if (index == this.events.size()) {
                throw new RuntimeException("UPR command: structure not recognised");
            }
            IParserEvent event = this.events.get(index);
            if (event.getType() == ParserEventType.COMMAND_EVENT && (command = (CommandEvent)event).getCommand() == Command.ud) break;
            ++index;
        }
        if (index == this.events.size()) {
            throw new RuntimeException("UPR command: structure not recognised: unable to locate UD command");
        }
        if (this.events.get(++index).getType() != ParserEventType.GROUP_START_EVENT) {
            throw new RuntimeException("UPR command: expecting group start, found: " + (Object)((Object)this.events.get(index).getType()));
        }
        int groupCount = 1;
        for (endIndex = ++index; endIndex != this.events.size(); ++endIndex) {
            IParserEvent event = this.events.get(endIndex);
            switch (event.getType()) {
                case GROUP_START_EVENT: {
                    ++groupCount;
                    break;
                }
                case GROUP_END_EVENT: {
                    --groupCount;
                    break;
                }
            }
            if (groupCount == 0) break;
        }
        if (index == this.events.size()) {
            throw new RuntimeException("UPR command: structure not recognised: unable to locate UD group end");
        }
        while (index <= endIndex) {
            this.handler.handleEvent(this.events.get(index));
            ++index;
        }
        this.complete = true;
    }
}

