/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffreyning.mybatisplus.service;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.github.jeffreyning.mybatisplus.anno.MppMultiId;
import com.github.jeffreyning.mybatisplus.base.MppBaseMapper;
import com.github.jeffreyning.mybatisplus.service.IMppService;
import com.github.jeffreyning.mybatisplus.util.CheckId;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.binding.MapperMethod;
import org.springframework.transaction.annotation.Transactional;

public class MppServiceImpl<M extends MppBaseMapper<T>, T>
extends ServiceImpl<M, T>
implements IMppService<T> {
    private String getCol(List<TableFieldInfo> fieldList, String attrName) {
        for (TableFieldInfo tableFieldInfo : fieldList) {
            String prop = tableFieldInfo.getProperty();
            if (!prop.equals(attrName)) continue;
            return tableFieldInfo.getColumn();
        }
        throw new RuntimeException("not found column for " + attrName);
    }

    private Map checkIdCol(Class<?> modelClass, TableInfo tableInfo) {
        List fieldList = tableInfo.getFieldList();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (TableFieldInfo fieldInfo : fieldList) {
            Field field = fieldInfo.getField();
            MppMultiId mppMultiId = field.getAnnotation(MppMultiId.class);
            if (mppMultiId == null) continue;
            String attrName = field.getName();
            String colName = this.getCol(fieldList, attrName);
            idMap.put(attrName, colName);
        }
        CheckId.appendIdColum(modelClass, tableInfo, idMap);
        return idMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateByMultiId(T entity) {
        Object obj;
        if (null == entity) {
            return false;
        }
        Class<?> cls = entity.getClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        Map idMap = this.checkIdCol(cls, tableInfo);
        Assert.notEmpty((Map)idMap, (String)"entity {} not contain MppMultiId anno", (Object[])new Object[]{cls.getName()});
        boolean updateFlag = true;
        for (String attr : idMap.keySet()) {
            if (!StringUtils.checkValNull((Object)attr)) continue;
            updateFlag = false;
            break;
        }
        if (updateFlag && Objects.isNull(obj = this.selectByMultiId(entity))) {
            updateFlag = false;
        }
        return updateFlag ? this.updateByMultiId(entity) : this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatchByMultiId(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.entityClass);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        Map idMap = this.checkIdCol(this.entityClass, tableInfo);
        Assert.notEmpty((Map)idMap, (String)"entity {} not contain MppMultiId anno", (Object[])new Object[]{this.entityClass.getName()});
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            Object obj;
            boolean updateFlag = true;
            for (String attr : idMap.keySet()) {
                if (!StringUtils.checkValNull((Object)attr)) continue;
                updateFlag = false;
                break;
            }
            if (updateFlag && Objects.isNull(obj = this.selectByMultiId(entity))) {
                updateFlag = false;
            }
            if (updateFlag) {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", entity);
                sqlSession.update(tableInfo.getSqlStatement("updateByMultiId"), (Object)param);
            } else {
                sqlSession.insert(tableInfo.getSqlStatement(SqlMethod.INSERT_ONE.getMethod()), entity);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchByMultiId(Collection<T> entityList, int batchSize) {
        String sqlStatement = SqlHelper.table((Class)this.entityClass).getSqlStatement("updateByMultiId");
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }
}

