/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.util;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.pinyin.bs.PinyinBs;
import com.github.houbb.pinyin.constant.enums.PinyinStyleEnum;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.style.PinyinToneStyles;
import java.util.List;

public final class PinyinHelper {
    private PinyinHelper() {
    }

    public static String toPinyin(String string) {
        return PinyinHelper.toPinyin(string, PinyinStyleEnum.DEFAULT);
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum) {
        if (StringUtil.isEmptyTrim((String)string)) {
            return string;
        }
        IPinyinToneStyle style = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(style).toPinyin(string);
    }

    public static List<String> toPinyinList(char chinese) {
        return PinyinBs.newInstance().toPinyinList(chinese);
    }

    public static List<String> toPinyinList(char chinese, PinyinStyleEnum styleEnum) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(pinyinTone).toPinyinList(chinese);
    }

    public static boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        return PinyinBs.newInstance().hasSamePinyin(chineseOne, chineseTwo);
    }

    public static List<Integer> toneNumList(String chinese) {
        return PinyinBs.newInstance().toneNumList(chinese);
    }

    public static List<Integer> toneNumList(char chinese) {
        return PinyinBs.newInstance().toneNumList(chinese);
    }

    public static List<String> shengMuList(String chinese) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(PinyinStyleEnum.NORMAL);
        return PinyinBs.newInstance().style(pinyinTone).shengMuList(chinese);
    }

    public static List<String> yunMuList(String chinese) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(PinyinStyleEnum.NORMAL);
        return PinyinBs.newInstance().style(pinyinTone).yunMuList(chinese);
    }
}

