/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.support.tone;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.pinyin.api.IPinyinContext;
import com.github.houbb.pinyin.spi.IPinyinTone;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPinyinTone
implements IPinyinTone {
    protected abstract String getCharTone(String var1, IPinyinToneStyle var2);

    protected abstract List<String> getCharTones(String var1, IPinyinToneStyle var2);

    protected abstract String getPhraseTone(String var1, IPinyinToneStyle var2);

    @Override
    public String tone(String segment, IPinyinContext context) {
        String result;
        int length = segment.length();
        final IPinyinToneStyle toneStyle = context.style();
        if (length == 1) {
            this.getCharToneDefault(segment, toneStyle);
        }
        if (StringUtil.isNotEmpty((String)(result = this.getPhraseTone(segment, toneStyle)))) {
            return result;
        }
        List chars = StringUtil.toCharStringList((String)segment);
        List tones = CollectionUtil.toList((Iterable)chars, (IHandler)new IHandler<String, String>(){

            public String handle(String string) {
                return AbstractPinyinTone.this.getCharToneDefault(string, toneStyle);
            }
        });
        return StringUtil.join((Collection)tones, (String)" ");
    }

    private String getCharToneDefault(String string, IPinyinToneStyle toneStyle) {
        String pinyin = this.getCharTone(string, toneStyle);
        if (StringUtil.isNotEmpty((String)pinyin)) {
            return pinyin;
        }
        return string;
    }

    @Override
    public List<String> toneList(String chinese, IPinyinContext context) {
        IPinyinToneStyle toneStyle = context.style();
        return this.getCharTonesDefault(chinese, toneStyle);
    }

    private List<String> getCharTonesDefault(String chinese, IPinyinToneStyle toneStyle) {
        List<String> toneList = this.getCharTones(chinese, toneStyle);
        if (CollectionUtil.isNotEmpty(toneList)) {
            return toneList;
        }
        return Collections.singletonList(chinese);
    }
}

