/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.bs;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.pinyin.api.IPinyin;
import com.github.houbb.pinyin.api.IPinyinContext;
import com.github.houbb.pinyin.api.impl.Pinyin;
import com.github.houbb.pinyin.api.impl.PinyinContext;
import com.github.houbb.pinyin.spi.IPinyinChinese;
import com.github.houbb.pinyin.spi.IPinyinData;
import com.github.houbb.pinyin.spi.IPinyinSegment;
import com.github.houbb.pinyin.spi.IPinyinTone;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.chinese.PinyinChineses;
import com.github.houbb.pinyin.support.data.PinyinData;
import com.github.houbb.pinyin.support.segment.DefaultPinyinSegment;
import com.github.houbb.pinyin.support.style.PinyinToneStyles;
import com.github.houbb.pinyin.support.tone.DefaultPinyinTone;
import java.util.List;

public final class PinyinBs {
    private IPinyinSegment pinyinSegment = (IPinyinSegment)Instances.singleton(DefaultPinyinSegment.class);
    private IPinyinChinese pinyinChinese = PinyinChineses.simple();
    private IPinyinTone pinyinTone = (IPinyinTone)Instances.singleton(DefaultPinyinTone.class);
    private IPinyinData data = (IPinyinData)Instances.singleton(PinyinData.class);
    private IPinyinToneStyle style = PinyinToneStyles.defaults();
    private IPinyin pinyin = (IPinyin)Instances.singleton(Pinyin.class);

    private PinyinBs() {
    }

    public static PinyinBs newInstance() {
        return new PinyinBs();
    }

    public PinyinBs style(IPinyinToneStyle style) {
        ArgUtil.notNull((Object)style, (String)"style");
        this.style = style;
        return this;
    }

    public String toPinyin(String string) {
        return this.pinyin.toPinyin(string, this.buildPinyinContext());
    }

    public List<String> toPinyinList(char chinese) {
        return this.pinyin.toPinyinList(chinese, this.buildPinyinContext());
    }

    public boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        return this.pinyin.hasSamePinyin(chineseOne, chineseTwo, this.buildPinyinContext());
    }

    public List<Integer> toneNumList(String chinese) {
        return this.pinyin.toneNumList(chinese, this.buildPinyinContext());
    }

    public List<Integer> toneNumList(char chinese) {
        return this.pinyin.toneNumList(chinese, this.buildPinyinContext());
    }

    public List<String> shengMuList(String chinese) {
        return this.pinyin.shengMuList(chinese, this.buildPinyinContext());
    }

    public List<String> yunMuList(String chinese) {
        return this.pinyin.yunMuList(chinese, this.buildPinyinContext());
    }

    private IPinyinContext buildPinyinContext() {
        return PinyinContext.newInstance().chinese(this.pinyinChinese).data(this.data).segment(this.pinyinSegment).style(this.style).tone(this.pinyinTone);
    }
}

