/*
 * Decompiled with CFR 0.152.
 */
package com.github.harryemartland.queryrunner.domain.query;

import com.github.harryemartland.queryrunner.domain.argument.value.ArgumentValue;
import com.github.harryemartland.queryrunner.domain.query.Query;
import com.github.harryemartland.queryrunner.domain.query.QueryResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractBooleanQuery
implements Query {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBooleanQuery.class);

    @Override
    public QueryResult getResult(List<ArgumentValue> argumentValues) {
        try {
            return this.runQueryAndReturnResult(argumentValues);
        }
        catch (EmptyResultDataAccessException e) {
            LOG.trace("Result not found: {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return QueryResult.NOT_FOUND;
        }
    }

    private QueryResult runQueryAndReturnResult(List<ArgumentValue> argumentValues) {
        if (this.runQuery(argumentValues).booleanValue()) {
            return QueryResult.OK;
        }
        return QueryResult.FAIL;
    }

    private Boolean runQuery(List<ArgumentValue> argumentValues) {
        return (Boolean)this.getJdbcTemplate().queryForObject(this.getQuery(), this.getArgs(argumentValues), Boolean.class);
    }

    protected abstract Object[] getArgs(List<ArgumentValue> var1);

    protected abstract JdbcTemplate getJdbcTemplate();

    protected abstract String getQuery();
}

