/*
 * Decompiled with CFR 0.152.
 */
package com.yunkuent.sdk;

import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.utils.Util;
import com.yunkuent.sdk.EntEngine;
import com.yunkuent.sdk.EntLibManager;
import com.yunkuent.sdk.HostConfig;
import java.util.HashMap;

public class EntManager
extends EntEngine {
    private final String URL_API_ADD_SYNC_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/add_sync_member";
    private final String URL_API_DEL_SYNC_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/del_sync_member";
    private final String URL_API_ADD_SYNC_GROUP = HostConfig.API_ENT_HOST + "/1/ent/add_sync_group";
    private final String URL_API_DEL_SYNC_GROUP = HostConfig.API_ENT_HOST + "/1/ent/del_sync_group";
    private final String URL_API_ADD_SYNC_GROUP_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/add_sync_group_member";
    private final String URL_API_DEL_SYNC_GROUP_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/del_sync_group_member";
    private final String URL_API_DEL_SYNC_MEMBER_GROUP = HostConfig.API_ENT_HOST + "/1/ent/del_sync_member_group";
    private final String URL_API_GET_MEMBER_BY_OUT_ID = HostConfig.API_ENT_HOST + "/1/ent/get_member_by_out_id";
    private final String URL_API_ADD_SYNC_ADMIN = HostConfig.API_ENT_HOST + "/1/ent/add_sync_admin";
    private final String URL_API_ADD_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/add_member";
    private final String URL_API_SET_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/set_member";
    private final String URL_API_DEL_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/del_member";
    private final String URL_API_ADD_GROUP = HostConfig.API_ENT_HOST + "/1/ent/add_group";
    private final String URL_API_SET_GROUP = HostConfig.API_ENT_HOST + "/1/ent/set_group";
    private final String URL_API_DEL_GROUP = HostConfig.API_ENT_HOST + "/1/ent/del_group";
    private final String URL_API_ADD_GROUP_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/add_group_member";
    private final String URL_API_DEL_GROUP_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/del_group_member";
    private final String URL_API_DEL_MEMBER_GROUP = HostConfig.API_ENT_HOST + "/1/ent/del_member_group";
    private final String URL_API_GET_MEMBERS = HostConfig.API_ENT_HOST + "/1/ent/get_members";
    private final String URL_API_GET_MEMBER = HostConfig.API_ENT_HOST + "/1/ent/get_member";
    private final String URL_API_GET_GROUPS = HostConfig.API_ENT_HOST + "/1/ent/get_groups";
    private final String URL_API_GET_GROUP_MEMBERS = HostConfig.API_ENT_HOST + "/1/ent/get_group_members";
    private final String URL_API_GET_ROLES = HostConfig.API_ENT_HOST + "/1/ent/get_roles";
    private final String URL_API_GET_GROUP_BY_OUT_ID = HostConfig.API_ENT_HOST + "/1/ent/get_group_by_out_id";
    private final String URL_API_ENT_LOG = HostConfig.API_ENT_HOST + "/1/ent/log";

    public EntManager(String clientId, String secret) {
        super(clientId, secret);
    }

    public ReturnResult addSyncMember(String outId, String memberName, String account, String memberEmail, String memberPhone, String password, String state) {
        String url = this.URL_API_ADD_SYNC_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("out_id", outId);
        params.put("member_name", memberName);
        params.put("account", account);
        params.put("member_email", memberEmail);
        params.put("member_phone", memberPhone);
        params.put("password", password);
        params.put("state", state);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setSyncMemberState(String oudId, boolean state) {
        String url = this.URL_API_ADD_SYNC_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("out_id", oudId);
        params.put("state", state ? "1" : "0");
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delSyncMember(String[] members) {
        String url = this.URL_API_DEL_SYNC_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult addSyncGroup(String outId, String name, String parentOutId) {
        String url = this.URL_API_ADD_SYNC_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("out_id", outId);
        params.put("name", name);
        params.put("parent_out_id", parentOutId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delSyncGroup(String[] groups) {
        String url = this.URL_API_DEL_SYNC_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groups", Util.strArrayToString((String[])groups, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult addSyncGroupMember(String groupOutId, String[] members) {
        String url = this.URL_API_ADD_SYNC_GROUP_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_out_id", groupOutId);
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delSyncGroupMember(String groupOutId, String[] members) {
        String url = this.URL_API_DEL_SYNC_GROUP_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_out_id", groupOutId);
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delSyncMemberGroup(String[] members) {
        String url = this.URL_API_DEL_SYNC_MEMBER_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    private ReturnResult getMemberByIds(String[] outIds, String[] userIds) {
        String url = this.URL_API_GET_MEMBER_BY_OUT_ID;
        HashMap<String, String> params = new HashMap<String, String>();
        if (outIds != null && outIds.length > 0) {
            params.put("out_ids", Util.strArrayToString((String[])outIds, (String)","));
        } else {
            params.put("out_ids", Util.strArrayToString((String[])userIds, (String)","));
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getMemberByOutids(String[] outIds) {
        return this.getMemberByIds(null, outIds);
    }

    public ReturnResult getMemberByUserIds(String[] userIds) {
        return this.getMemberByIds(userIds, null);
    }

    public ReturnResult addSyncAdmin(String outId, String memberEmail, boolean isSuperAdmin) {
        String url = this.URL_API_ADD_SYNC_ADMIN;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("out_id", outId);
        params.put("member_email", memberEmail);
        params.put("type", isSuperAdmin ? "1" : "0");
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult addMember(String account, String password, String name, String phone, String title, Boolean state, String groupPath) {
        String url = this.URL_API_ADD_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        params.put("password", password);
        params.put("member_name", name);
        params.put("member_phone", phone);
        params.put("member_title", title);
        if (state != null) {
            params.put("state", state != false ? "1" : "0");
        }
        params.put("group_path", groupPath);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setMember(String account, String name, String phone, String title, String password, Boolean state) {
        String url = this.URL_API_SET_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        params.put("member_name", name);
        params.put("member_phone", phone);
        params.put("member_title", title);
        params.put("password", password);
        if (state != null) {
            params.put("state", state != false ? "1" : "0");
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delMember(String[] members) {
        String url = this.URL_API_DEL_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult addGroup(String name, String parentGroupPath, int orderby, Boolean state) {
        String url = this.URL_API_ADD_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_name", name);
        params.put("parent_group_path", parentGroupPath);
        params.put("orderby", String.valueOf(orderby));
        if (state != null) {
            params.put("state", state != false ? "1" : "0");
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setGroup(String groupPath, String name, String parentGroupPath, int orderby, Boolean state) {
        String url = this.URL_API_SET_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_path", groupPath);
        params.put("group_name", name);
        params.put("parent_group_path", parentGroupPath);
        params.put("orderby", String.valueOf(orderby));
        if (state != null) {
            params.put("state", state != false ? "1" : "0");
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delGroup(String[] groupPaths) {
        String url = this.URL_API_DEL_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groups", Util.strArrayToString((String[])groupPaths, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    private ReturnResult setGroupMember(String groupPath, String[] members, boolean add) {
        String url = add ? this.URL_API_ADD_GROUP_MEMBER : this.URL_API_DEL_GROUP_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_path", groupPath);
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult addGroupMember(String groupPath, String[] members) {
        return this.setGroupMember(groupPath, members, true);
    }

    public ReturnResult delGroupMember(String groupPath, String[] members) {
        return this.setGroupMember(groupPath, members, false);
    }

    public ReturnResult delMemberGroup(String[] members) {
        String url = this.URL_API_DEL_MEMBER_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("members", Util.strArrayToString((String[])members, (String)","));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getMembers(int start, int size) {
        String url = this.URL_API_GET_MEMBERS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    private ReturnResult getMember(int memberId, String outId, String account, String email, boolean showGroups) {
        String url = this.URL_API_GET_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        if (memberId > 0) {
            params.put("member_id", Integer.toString(memberId));
        }
        if (!Util.isEmpty((CharSequence)outId)) {
            params.put("out_id", outId);
        }
        if (!Util.isEmpty((CharSequence)account)) {
            params.put("account", account);
        }
        if (!Util.isEmpty((CharSequence)email)) {
            params.put("email", email);
        }
        if (showGroups) {
            params.put("show_groups", "1");
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getMemberById(int memberId, boolean showGroups) {
        return this.getMember(memberId, null, null, null, showGroups);
    }

    public ReturnResult getMemberByOutId(String outId, boolean showGroups) {
        return this.getMember(0, outId, null, null, showGroups);
    }

    public ReturnResult getMemberByAccount(String account, boolean showGroups) {
        return this.getMember(0, null, account, null, showGroups);
    }

    public ReturnResult getMemberByEmail(String email, boolean showGroups) {
        return this.getMember(0, null, null, email, showGroups);
    }

    public ReturnResult getGroups() {
        String url = this.URL_API_GET_GROUPS;
        return new EntEngine.RequestHelper(this).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    private ReturnResult getGroupMembers(int groupId, String groupOutId, String groupPath, int start, int size, boolean showChild) {
        String url = this.URL_API_GET_GROUP_MEMBERS;
        HashMap<String, String> params = new HashMap<String, String>();
        if (groupId > 0) {
            params.put("group_id", Integer.toString(groupId));
        }
        if (!Util.isEmpty((CharSequence)groupOutId)) {
            params.put("out_id", groupOutId);
        }
        if (!Util.isEmpty((CharSequence)groupPath)) {
            params.put("group_path", groupPath);
        }
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        params.put("show_child", showChild ? "1" : "0");
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getGroupMembers(int groupId, int start, int size, boolean showChild) {
        return this.getGroupMembers(groupId, null, null, start, size, showChild);
    }

    public ReturnResult getGroupMembersByOutId(String groupOutId, int start, int size, boolean showChild) {
        return this.getGroupMembers(0, groupOutId, null, start, size, showChild);
    }

    public ReturnResult getGroupMembersByGroupPath(String groupPath, int start, int size, boolean showChild) {
        return this.getGroupMembers(0, null, groupPath, start, size, showChild);
    }

    public ReturnResult getRoles() {
        String url = this.URL_API_GET_ROLES;
        return new EntEngine.RequestHelper(this).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getGroupByOutID(String clientId, String[] outIds) {
        String url = this.URL_API_GET_GROUP_BY_OUT_ID;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("out_ids", Util.strArrayToString((String[])outIds, (String)","));
        params.put("dateline", Util.getUnixDateline() + "");
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getLogByClientId(String clientId, entType entType2, EntLibManager.OrderBy orderby, Long startDateline, Long endDateline, int start, int size) {
        return this.getLog(clientId, entType2, orderby, startDateline, endDateline, start, size);
    }

    private ReturnResult getLog(String clientId, entType entType2, EntLibManager.OrderBy orderby, Long startDateline, Long endDateline, int start, int size) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("dateline", Util.getUnixDateline() + "");
        if (entType2 != null) {
            params.put("type", entType2.toString());
        }
        if (orderby != null) {
            params.put("orderby", orderby.toString());
        }
        if (startDateline != null) {
            params.put("start_dateline", startDateline.toString());
        }
        if (endDateline != null) {
            params.put("end_dateline", endDateline.toString());
        }
        if (start > 0) {
            params.put("start", Integer.toString(start));
        }
        if (size > 0) {
            params.put("size", Integer.toString(size));
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_ENT_LOG).setMethod(RequestMethod.POST).executeSync();
    }

    public static enum entType {
        SUB_ADMIN("1"),
        MEMBER_INFO("2"),
        COMPANY_SETTING("3"),
        ORG_STRUCTURE("4"),
        ROLE("5"),
        MEMBER_DEVICE("6"),
        STORAGE_POINT("7"),
        FILE_LIBRARY("8"),
        DEV_AUTH("9");

        private String entType;

        private entType(String entType2) {
            this.entType = entType2;
        }

        public String toString() {
            return this.entType;
        }
    }
}

