/*
 * Decompiled with CFR 0.152.
 */
package com.yunkuent.sdk;

import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.utils.Util;
import com.yunkuent.sdk.EntEngine;
import com.yunkuent.sdk.HostConfig;
import com.yunkuent.sdk.MemberType;
import java.util.HashMap;

public class EntLibManager
extends EntEngine {
    private final String URL_API_CREATE_LIB = HostConfig.API_ENT_HOST + "/1/org/create";
    private final String URL_API_SET = HostConfig.API_ENT_HOST + "/1/org/set";
    private final String URL_API_GET_INFO = HostConfig.API_ENT_HOST + "/1/org/info";
    private final String URL_API_INFO_BY_MEMBER = HostConfig.API_ENT_HOST + "/1/org/info_by_member";
    private final String URL_API_SET_BY_MEMBER = HostConfig.API_ENT_HOST + "/1/org/set_by_member";
    private final String URL_API_GET_LIB_LIST = HostConfig.API_ENT_HOST + "/1/org/ls";
    private final String URL_API_BIND = HostConfig.API_ENT_HOST + "/1/org/bind";
    private final String URL_API_UNBIND = HostConfig.API_ENT_HOST + "/1/org/unbind";
    private final String URL_API_GET_MEMBERS = HostConfig.API_ENT_HOST + "/1/org/get_members";
    private final String URL_API_GET_MEMBER = HostConfig.API_ENT_HOST + "/1/org/get_member";
    private final String URL_API_SET_OWNER = HostConfig.API_ENT_HOST + "/1/org/set_owner";
    private final String URL_API_ADD_MEMBERS = HostConfig.API_ENT_HOST + "/1/org/add_member";
    private final String URL_API_SET_MEMBER_ROLE = HostConfig.API_ENT_HOST + "/1/org/set_member_role";
    private final String URL_API_DEL_MEMBER = HostConfig.API_ENT_HOST + "/1/org/del_member";
    private final String URL_API_GET_GROUPS = HostConfig.API_ENT_HOST + "/1/org/get_groups";
    private final String URL_API_ADD_GROUP = HostConfig.API_ENT_HOST + "/1/org/add_group";
    private final String URL_API_DEL_GROUP = HostConfig.API_ENT_HOST + "/1/org/del_group";
    private final String URL_API_SET_GROUP_ROLE = HostConfig.API_ENT_HOST + "/1/org/set_group_role";
    private final String URL_API_DESTROY = HostConfig.API_ENT_HOST + "/1/org/destroy";
    private final String URL_API_LOG = HostConfig.API_ENT_HOST + "/1/org/log";

    public EntLibManager(String clientId, String secret) {
        super(clientId, secret);
    }

    public ReturnResult create(String orgName, String orgCapacity, String storagePointName, String orgLogo) {
        String url = this.URL_API_CREATE_LIB;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_name", orgName);
        params.put("org_capacity", orgCapacity);
        params.put("storage_point_name", storagePointName);
        params.put("org_logo", orgLogo);
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getLibList() {
        return this.getLibList(0, 0);
    }

    public ReturnResult getLibList(int memberId, int type) {
        String url = this.URL_API_GET_LIB_LIST;
        HashMap<String, String> params = new HashMap<String, String>();
        if (memberId > 0) {
            params.put("member_id", memberId + "");
        }
        params.put("type", type + "");
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult bind(int orgId, String appName) {
        String url = this.URL_API_BIND;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", String.valueOf(orgId));
        params.put("title", appName);
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult unBind(String orgClientId) {
        String url = this.URL_API_UNBIND;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_client_id", orgClientId);
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getMembers(int start, int size, int orgId) {
        String url = this.URL_API_GET_MEMBERS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult addMembers(int orgId, int roleId, int[] memberIds) {
        String url = this.URL_API_ADD_MEMBERS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("role_id", Integer.toString(roleId));
        params.put("member_ids", Util.intArrayToString((int[])memberIds, (String)","));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setMemberRole(int orgId, int roleId, int[] memberIds) {
        String url = this.URL_API_SET_MEMBER_ROLE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("role_id", Integer.toString(roleId));
        params.put("member_ids", Util.intArrayToString((int[])memberIds, (String)","));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delMember(int orgId, int[] memberIds) {
        String url = this.URL_API_DEL_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("member_ids", Util.intArrayToString((int[])memberIds, (String)","));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getGroups(int orgId) {
        String url = this.URL_API_GET_GROUPS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult addGroup(int orgId, int groupId, int roleId) {
        String url = this.URL_API_ADD_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("group_id", Integer.toString(groupId));
        params.put("role_id", Integer.toString(roleId));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delGroup(int orgId, int groupId) {
        String url = this.URL_API_DEL_GROUP;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("group_id", Integer.toString(groupId));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setGroupRole(int orgId, int groupId, int roleId) {
        String url = this.URL_API_SET_GROUP_ROLE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("group_id", Integer.toString(groupId));
        params.put("role_id", Integer.toString(roleId));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult destroy(int orgId) {
        String url = this.URL_API_DESTROY;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult destroyByOrgClientId(String orgClientId) {
        String url = this.URL_API_DESTROY;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_client_id", orgClientId);
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult set(int orgId, String orgName, String orgCapacity, String orgLogo) {
        String url = this.URL_API_SET;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        if (!Util.isEmpty((CharSequence)orgName)) {
            params.put("org_name", orgName);
        }
        if (!Util.isEmpty((CharSequence)orgCapacity)) {
            params.put("org_capacity", orgCapacity);
        }
        if (!Util.isEmpty((CharSequence)orgLogo)) {
            params.put("org_logo", orgLogo);
        }
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getMember(int orgId, MemberType type, String[] ids) {
        String url = this.URL_API_GET_MEMBER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        params.put("type", type.toString().toLowerCase());
        params.put("ids", Util.strArrayToString((String[])ids, (String)","));
        return new EntEngine.RequestHelper().setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getInfo(int orgId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", Integer.toString(orgId));
        return new EntEngine.RequestHelper().setParams(params).setUrl(this.URL_API_GET_INFO).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getInfoByMembmer(int memberId, String outId, String account, String email) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (memberId > 0) {
            params.put("member_id", Integer.toString(memberId));
        } else if (!Util.isEmpty((CharSequence)outId)) {
            params.put("out_id", outId);
        } else if (!Util.isEmpty((CharSequence)account)) {
            params.put("account", account);
        } else if (!Util.isEmpty((CharSequence)email)) {
            params.put("email", email);
        }
        return new EntEngine.RequestHelper().setParams(params).setUrl(this.URL_API_INFO_BY_MEMBER).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult setByMembmer(int memberId, String outId, String account, String email, long capacity) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (memberId > 0) {
            params.put("member_id", Integer.toString(memberId));
        } else if (!Util.isEmpty((CharSequence)outId)) {
            params.put("out_id", outId);
        } else if (!Util.isEmpty((CharSequence)account)) {
            params.put("account", account);
        } else if (!Util.isEmpty((CharSequence)email)) {
            params.put("email", email);
        }
        params.put("capacity", Long.toString(capacity));
        return new EntEngine.RequestHelper().setParams(params).setUrl(this.URL_API_SET_BY_MEMBER).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getLogByOrgId(int orgId, Act[] acts, OrderBy orderby, Long startDateline, Long endDateline, int start, int size) {
        return this.getLog(orgId, 0, acts, orderby, startDateline, endDateline, start, size);
    }

    public ReturnResult getLogByMountId(int mountId, Act[] acts, OrderBy orderby, Long startDateline, Long endDateline, int start, int size) {
        return this.getLog(mountId, 0, acts, orderby, startDateline, endDateline, start, size);
    }

    private ReturnResult getLog(int orgId, int mountId, Act[] acts, OrderBy orderby, Long startDateline, Long endDateline, int start, int size) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orgId > 0) {
            params.put("org_id", Integer.toString(orgId));
        } else if (mountId > 0) {
            params.put("mount_id", Integer.toString(mountId));
        }
        if (acts != null && acts.length > 0) {
            params.put("act", Util.ArrayToString((Object[])acts, (String)","));
        }
        if (orderby != null) {
            params.put("orderby", orderby.toString());
        }
        if (startDateline != null) {
            params.put("start_dateline", startDateline.toString());
        }
        if (endDateline != null) {
            params.put("end_dateline", endDateline.toString());
        }
        if (start > 0) {
            params.put("start", Integer.toString(start));
        }
        if (size > 0) {
            params.put("size", Integer.toString(size));
        }
        return new EntEngine.RequestHelper().setParams(params).setUrl(this.URL_API_LOG).setMethod(RequestMethod.GET).executeSync();
    }

    public static enum Act {
        DELETE("0"),
        CREATE("1"),
        RENAME("2"),
        EDIT("3"),
        MOVE("4"),
        RECOVER("5"),
        REVERT("6"),
        LOCK("12"),
        UNLOCK("13"),
        DOWNLOAD("20"),
        PREVIEW("21"),
        LINK_CREATE("1014"),
        LINK_ACCESS("1015"),
        LINK_DOWNLOAD("1016"),
        LINK_SAVE("1017"),
        LINK_UPLOAD("1018");

        private String act;

        private Act(String act) {
            this.act = act;
        }

        public String toString() {
            return this.act;
        }
    }

    public static enum OrderBy {
        ASC("asc"),
        DESC("desc");

        private String order;

        private OrderBy(String order) {
            this.order = order;
        }

        public String toString() {
            return this.order;
        }
    }
}

