/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.bootstrap.arg.StartArgs;
import com.github.dreamhead.moco.parser.GlobalSettingParser;
import com.github.dreamhead.moco.parser.model.GlobalSetting;
import com.github.dreamhead.moco.runner.JsonRunner;
import com.github.dreamhead.moco.runner.Runner;
import com.github.dreamhead.moco.runner.RunnerSetting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SettingRunner
implements Runner {
    private final GlobalSettingParser parser = new GlobalSettingParser();
    private final ImmutableList<GlobalSetting> globalSettings;
    private final String env;
    private final StartArgs startArgs;
    private Runner runner;
    private final List<File> files;

    public SettingRunner(InputStream stream, StartArgs args) {
        this.env = args.getEnv().orElse(null);
        this.globalSettings = this.parser.parse(stream);
        this.files = this.globalSettings.stream().flatMap(this.toFiles()).collect(Collectors.toList());
        this.startArgs = args;
    }

    public Iterable<File> getFiles() {
        return this.files;
    }

    @Override
    public void run() {
        this.runner = JsonRunner.newJsonRunnerWithSetting(this.globalSettings.stream().filter(this.byEnv(this.env)).map(this.toRunnerSetting()).collect(Collectors.toList()), this.startArgs);
        this.runner.run();
    }

    private Predicate<? super GlobalSetting> byEnv(String env) {
        return globalSetting -> env == null || env.equalsIgnoreCase(globalSetting.getEnv());
    }

    private Function<GlobalSetting, RunnerSetting> toRunnerSetting() {
        return setting -> RunnerSetting.aRunnerSetting().addStreams((ImmutableList<InputStream>)((ImmutableList)setting.includes().stream().map(this.toStream()).collect(ImmutableList.toImmutableList()))).withContext(setting.getContext()).withFileRoot(setting.getFileRoot()).withRequest(setting.getRequest()).withResponse(setting.getResponse()).build();
    }

    private Function<String, InputStream> toStream() {
        return input -> {
            try {
                return new FileInputStream((String)input);
            }
            catch (FileNotFoundException e) {
                throw new MocoException((Throwable)e);
            }
        };
    }

    @Override
    public void stop() {
        this.runner.stop();
    }

    private Function<? super GlobalSetting, Stream<? extends File>> toFiles() {
        return input -> input.includes().stream().map(File::new);
    }
}

