/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.image.Image;
import org.apache.pdfbox.pdmodel.PDPage;

public class ImageCell<T extends PDPage>
extends Cell<T> {
    private Image img;
    private final HorizontalAlignment align;
    private final VerticalAlignment valign;

    ImageCell(Row<T> row, float width, Image image, boolean isCalculated) {
        super(row, width, null, isCalculated);
        this.img = image;
        if (image.getWidth() > this.getInnerWidth()) {
            this.scaleToFit();
        }
        this.align = HorizontalAlignment.LEFT;
        this.valign = VerticalAlignment.TOP;
    }

    public void scaleToFit() {
        this.img = this.img.scale(this.getInnerWidth());
    }

    ImageCell(Row<T> row, float width, Image image, boolean isCalculated, HorizontalAlignment align, VerticalAlignment valign) {
        super(row, width, null, isCalculated, align, valign);
        this.img = image;
        if (image.getWidth() > this.getInnerWidth()) {
            this.scaleToFit();
        }
        this.align = align;
        this.valign = valign;
    }

    @Override
    public float getTextHeight() {
        return this.img.getHeight();
    }

    @Override
    public float getHorizontalFreeSpace() {
        return this.getInnerWidth() - this.img.getWidth();
    }

    @Override
    public float getVerticalFreeSpace() {
        return this.getInnerHeight() - this.img.getHeight();
    }

    public Image getImage() {
        return this.img;
    }
}

