/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.zip;

import io.xjar.XDecryptor;
import io.xjar.XEntryDecryptor;
import io.xjar.XEntryFilter;
import io.xjar.XKit;
import io.xjar.XUnclosedOutputStream;
import io.xjar.key.XKey;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class XZipDecryptor
extends XEntryDecryptor<ZipArchiveEntry>
implements XDecryptor {
    private final int level;

    public XZipDecryptor(XDecryptor xEncryptor) {
        this(xEncryptor, (XEntryFilter<ZipArchiveEntry>)null);
    }

    public XZipDecryptor(XDecryptor xDecryptor, XEntryFilter<ZipArchiveEntry> filter) {
        this(xDecryptor, 8, filter);
    }

    public XZipDecryptor(XDecryptor xEncryptor, int level) {
        this(xEncryptor, level, null);
    }

    public XZipDecryptor(XDecryptor xDecryptor, int level, XEntryFilter<ZipArchiveEntry> filter) {
        super(xDecryptor, filter);
        this.level = level;
    }

    @Override
    public void decrypt(XKey key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.decrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        ZipArchiveInputStream zis = null;
        ZipArchiveOutputStream zos = null;
        try {
            ZipArchiveEntry entry;
            zis = new ZipArchiveInputStream(in);
            zos = new ZipArchiveOutputStream(out);
            zos.setLevel(this.level);
            XUnclosedOutputStream nos = new XUnclosedOutputStream((OutputStream)zos);
            while ((entry = zis.getNextZipEntry()) != null) {
                if (entry.isDirectory()) continue;
                zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entry.getName()));
                XDecryptor decryptor = this.filtrate(entry) ? this : this.xNopDecryptor;
                try (OutputStream eos = decryptor.decrypt(key, nos);){
                    XKit.transfer((InputStream)zis, eos);
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            XKit.close(zos);
            throw throwable;
        }
        XKit.close((Closeable)zis);
        XKit.close((Closeable)zos);
    }
}

