/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.boot;

import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XKit;
import io.xjar.boot.XBootURLHandler;
import io.xjar.key.XKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import org.springframework.boot.loader.LaunchedURLClassLoader;

public class XBootClassLoader
extends LaunchedURLClassLoader {
    private final XBootURLHandler xBootURLHandler;

    public XBootClassLoader(URL[] urls, ClassLoader parent, XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey) throws Exception {
        super(urls, parent);
        this.xBootURLHandler = new XBootURLHandler(xDecryptor, xEncryptor, xKey, (ClassLoader)((Object)this));
    }

    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)this.xBootURLHandler));
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enumeration = super.findResources(name);
        if (enumeration == null) {
            return null;
        }
        return new XBootEnumeration(enumeration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            URL resource = this.findResource(name.replace('.', '/') + ".class");
            if (resource == null) {
                throw new ClassNotFoundException(name, e);
            }
            try (InputStream in = resource.openStream();){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                XKit.transfer(in, bos);
                byte[] bytes = bos.toByteArray();
                Class clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            catch (Throwable t) {
                throw new ClassNotFoundException(name, t);
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class XBootEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> enumeration;

        XBootEnumeration(Enumeration<URL> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL url = this.enumeration.nextElement();
            if (url == null) {
                return null;
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)XBootClassLoader.this.xBootURLHandler));
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
    }
}

