/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.boot;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XEntryFilter;
import io.xjar.XJdkDecryptor;
import io.xjar.XJdkEncryptor;
import io.xjar.XKit;
import io.xjar.boot.XBootDecryptor;
import io.xjar.boot.XBootEncryptor;
import io.xjar.key.XKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class XBoot
implements XConstants {
    public static void encrypt(String src, String dest, XKey xKey) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), xKey);
    }

    public static void encrypt(String src, String dest, XKey xKey, int mode) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), xKey, mode);
    }

    public static void encrypt(File src, File dest, XKey xKey) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.encrypt((InputStream)in, (OutputStream)out, xKey);
        }
    }

    public static void encrypt(File src, File dest, XKey xKey, int mode) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.encrypt((InputStream)in, (OutputStream)out, xKey, mode);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor(new XJdkEncryptor(xKey.getAlgorithm()));
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey, int mode) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor((XEncryptor)new XJdkEncryptor(xKey.getAlgorithm()), 8, mode);
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), xKey, filter);
    }

    public static void encrypt(String src, String dest, XKey xKey, int mode, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), xKey, mode, filter);
    }

    public static void encrypt(File src, File dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.encrypt((InputStream)in, (OutputStream)out, xKey, filter);
        }
    }

    public static void encrypt(File src, File dest, XKey xKey, int mode, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.encrypt((InputStream)in, (OutputStream)out, xKey, mode, filter);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor((XEncryptor)new XJdkEncryptor(xKey.getAlgorithm()), filter);
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey, int mode, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor(new XJdkEncryptor(xKey.getAlgorithm()), 8, mode, filter);
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, String password) throws Exception {
        XBoot.encrypt(src, dest, password, "AES");
    }

    public static void encrypt(String src, String dest, String password, String algorithm) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, 128);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, keysize, 128);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize);
    }

    public static void encrypt(File src, File dest, String password) throws Exception {
        XBoot.encrypt(src, dest, password, "AES");
    }

    public static void encrypt(File src, File dest, String password, String algorithm) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, 128);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, keysize, 128);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.encrypt((InputStream)in, (OutputStream)out, password, algorithm, keysize, ivsize);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, String password) throws Exception {
        XBoot.encrypt(in, out, password, "AES");
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm) throws Exception {
        XBoot.encrypt(in, out, password, algorithm, 128);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize) throws Exception {
        XBoot.encrypt(in, out, password, algorithm, keysize, 128);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor(new XJdkEncryptor(algorithm));
        XKey xKey = XKit.key(algorithm, keysize, ivsize, password);
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, password, "AES", filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, 128, filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, keysize, 128, filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize, filter);
    }

    public static void encrypt(File src, File dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, password, "AES", filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, 128, filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, password, algorithm, keysize, 128, filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.encrypt(in, out, password, algorithm, keysize, ivsize, filter);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(in, out, password, "AES", filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(in, out, password, algorithm, 128, filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(in, out, password, algorithm, keysize, 128, filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor((XEncryptor)new XJdkEncryptor(algorithm), filter);
        XKey xKey = XKit.key(algorithm, keysize, ivsize, password);
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, XKey xKey) throws Exception {
        XBoot.decrypt(new File(src), new File(dest), xKey);
    }

    public static void decrypt(File src, File dest, XKey xKey) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.decrypt((InputStream)in, (OutputStream)out, xKey);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, XKey xKey) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor(new XJdkDecryptor(xKey.getAlgorithm()));
        xBootDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(new File(src), new File(dest), xKey, filter);
    }

    public static void decrypt(File src, File dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.decrypt((InputStream)in, (OutputStream)out, xKey, filter);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor((XDecryptor)new XJdkDecryptor(xKey.getAlgorithm()), filter);
        xBootDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, String password) throws Exception {
        XBoot.decrypt(src, dest, password, "AES");
    }

    public static void decrypt(String src, String dest, String password, String algorithm) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, 128);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, keysize, 128);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        XBoot.decrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize);
    }

    public static void decrypt(File src, File dest, String password) throws Exception {
        XBoot.decrypt(src, dest, password, "AES");
    }

    public static void decrypt(File src, File dest, String password, String algorithm) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, 128);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, keysize, 128);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.decrypt((InputStream)in, (OutputStream)out, password, algorithm, keysize, ivsize);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String password) throws Exception {
        XBoot.decrypt(in, out, password, "AES");
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm) throws Exception {
        XBoot.decrypt(in, out, password, algorithm, 128);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize) throws Exception {
        XBoot.decrypt(in, out, password, algorithm, keysize, 128);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor(new XJdkDecryptor(algorithm));
        XKey xKey = XKit.key(algorithm, keysize, ivsize, password);
        xBootDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, password, "AES", filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, 128, filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, keysize, 128, filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize, filter);
    }

    public static void decrypt(File src, File dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, password, "AES", filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, 128, filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, password, algorithm, keysize, 128, filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            XBoot.decrypt(in, out, password, algorithm, keysize, ivsize, filter);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(in, out, password, "AES", filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(in, out, password, algorithm, 128, filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(in, out, password, algorithm, keysize, 128, filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor((XDecryptor)new XJdkDecryptor(algorithm), filter);
        XKey xKey = XKit.key(algorithm, keysize, ivsize, password);
        xBootDecryptor.decrypt(xKey, in, out);
    }
}

