/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XConstants;
import io.xjar.XEntryFilter;
import io.xjar.filter.XAllEntryFilter;
import io.xjar.filter.XAnyEntryFilter;
import io.xjar.filter.XNotEntryFilter;
import io.xjar.key.XKey;
import io.xjar.key.XSecureRandom;
import io.xjar.key.XSymmetricSecureKey;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.Attributes;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public abstract class XKit
implements XConstants {
    public static byte[] readln(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (b != -1) {
            switch (b) {
                case 13: {
                    break;
                }
                case 10: {
                    return bos.toByteArray();
                }
                default: {
                    bos.write(b);
                }
            }
            b = in.read();
        }
        return bos.toByteArray();
    }

    public static void writeln(OutputStream out, byte[] line) throws IOException {
        if (line == null) {
            return;
        }
        out.write(line);
        out.write(13);
        out.write(10);
    }

    public static void close(Closeable closeable) {
        try {
            XKit.close(closeable, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void close(Closeable closeable, boolean quietly) throws IOException {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (quietly) break block3;
                throw e;
            }
        }
    }

    public static long transfer(InputStream in, OutputStream out) throws IOException {
        int length;
        long total = 0L;
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
            total += (long)length;
        }
        out.flush();
        return total;
    }

    public static long transfer(Reader reader, Writer writer) throws IOException {
        int length;
        long total = 0L;
        char[] buffer = new char[4096];
        while ((length = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, length);
            total += (long)length;
        }
        writer.flush();
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(InputStream in, File file) throws IOException {
        long l;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            l = XKit.transfer(in, out);
        }
        catch (Throwable throwable) {
            XKit.close(out);
            throw throwable;
        }
        XKit.close(out);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(Reader reader, File file) throws IOException {
        long l;
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        try {
            out = new FileOutputStream(file);
            writer = new OutputStreamWriter(out);
            l = XKit.transfer(reader, writer);
        }
        catch (Throwable throwable) {
            XKit.close(writer);
            XKit.close(out);
            throw throwable;
        }
        XKit.close(writer);
        XKit.close(out);
        return l;
    }

    public static boolean delete(File file) {
        return XKit.delete(file, false);
    }

    public static boolean delete(File file, boolean recursively) {
        if (file.isDirectory() && recursively) {
            boolean deleted = true;
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                deleted &= XKit.delete(files[i], true);
            }
            return deleted && file.delete();
        }
        return file.delete();
    }

    public static XKey key(String password) throws NoSuchAlgorithmException {
        return XKit.key("AES", 128, 128, password);
    }

    public static XKey key(String algorithm, String password) throws NoSuchAlgorithmException {
        return XKit.key(algorithm, 128, 128, password);
    }

    public static XKey key(String algorithm, int keysize, String password) throws NoSuchAlgorithmException {
        return XKit.key(algorithm, keysize, 128, password);
    }

    public static XKey key(String algorithm, int keysize, int ivsize, String password) throws NoSuchAlgorithmException {
        MessageDigest sha512 = MessageDigest.getInstance("SHA-512");
        byte[] seed = sha512.digest(password.getBytes());
        KeyGenerator generator = KeyGenerator.getInstance(algorithm.split("[/]")[0]);
        XSecureRandom random = new XSecureRandom(seed);
        generator.init(keysize, (SecureRandom)random);
        SecretKey key = generator.generateKey();
        generator.init(ivsize, (SecureRandom)random);
        SecretKey iv = generator.generateKey();
        return new XSymmetricSecureKey(algorithm, keysize, ivsize, password, key.getEncoded(), iv.getEncoded());
    }

    public static void retainKey(XKey key, Attributes attributes) {
        attributes.putValue("XJar-Algorithm", key.getAlgorithm());
        attributes.putValue("XJar-Keysize", String.valueOf(key.getKeysize()));
        attributes.putValue("XJar-Ivsize", String.valueOf(key.getIvsize()));
        attributes.putValue("XJar-Password", key.getPassword());
    }

    public static void removeKey(Attributes attributes) {
        attributes.remove(new Attributes.Name("XJar-Algorithm"));
        attributes.remove(new Attributes.Name("XJar-Keysize"));
        attributes.remove(new Attributes.Name("XJar-Ivsize"));
        attributes.remove(new Attributes.Name("XJar-Password"));
    }

    public static <E> XAllEntryFilter<E> all() {
        return new XAllEntryFilter();
    }

    public static <E> XAllEntryFilter<E> all(Collection<? extends XEntryFilter<E>> filters) {
        return new XAllEntryFilter(filters);
    }

    public static <E> XAllEntryFilter<E> and() {
        return new XAllEntryFilter();
    }

    public static <E> XAllEntryFilter<E> and(Collection<? extends XEntryFilter<E>> filters) {
        return new XAllEntryFilter(filters);
    }

    public static <E> XAnyEntryFilter<E> any() {
        return new XAnyEntryFilter();
    }

    public static <E> XAnyEntryFilter<E> any(Collection<? extends XEntryFilter<E>> filters) {
        return new XAnyEntryFilter(filters);
    }

    public static <E> XAnyEntryFilter<E> or() {
        return new XAnyEntryFilter();
    }

    public static <E> XAnyEntryFilter<E> or(Collection<? extends XEntryFilter<E>> filters) {
        return new XAnyEntryFilter(filters);
    }

    public static <E> XEntryFilter<E> not(XEntryFilter<E> filter) {
        return new XNotEntryFilter<E>(filter);
    }

    public static boolean isRelative(String path) {
        return !XKit.isAbsolute(path);
    }

    public static boolean isAbsolute(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        HashSet roots = new HashSet();
        Collections.addAll(roots, File.listRoots());
        File root = new File(path);
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        return roots.contains(root);
    }

    public static String absolutize(String path) {
        return XKit.normalize(XKit.isAbsolute(path) ? path : System.getProperty("user.dir") + File.separator + path);
    }

    public static String normalize(String path) {
        return path.replaceAll("[/\\\\]+", "/");
    }
}

