/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XDecryptor;
import io.xjar.XKit;
import io.xjar.key.XKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

public class XJdkDecryptor
implements XDecryptor {
    private final String algorithm;

    public XJdkDecryptor(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void decrypt(XKey key, File src, File dest) throws IOException {
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("could not make directory: " + dest.getParentFile());
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            this.decrypt(key, in, out);
        }
    }

    @Override
    public void decrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        CipherInputStream cis = null;
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, new SecretKeySpec(key.getDecryptKey(), this.algorithm));
            cis = new CipherInputStream(in, cipher);
            XKit.transfer((InputStream)cis, out);
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                XKit.close(cis);
                throw throwable;
            }
        }
        XKit.close(cis);
    }

    @Override
    public InputStream decrypt(XKey key, InputStream in) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, new SecretKeySpec(key.getDecryptKey(), this.algorithm));
            return new CipherInputStream(in, cipher);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream decrypt(XKey key, OutputStream out) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, new SecretKeySpec(key.getDecryptKey(), this.algorithm));
            return new CipherOutputStream(out, cipher);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

