/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.loadkit.Loader;
import io.loadkit.Loaders;
import io.loadkit.Resource;
import io.xjar.XArray;
import io.xjar.XEntryFilter;
import io.xjar.XExcludeAntEntryFilter;
import io.xjar.XIncludeAntEntryFilter;
import io.xjar.XKit;
import io.xjar.boot.XBoot;
import io.xjar.filter.XAllEntryFilter;
import io.xjar.filter.XAnyEntryFilter;
import io.xjar.jar.XJar;
import io.xjar.key.XKey;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE)
public class XBuilder
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="xjar.algorithm", required=true, defaultValue="AES/CBC/PKCS5Padding")
    private String algorithm;
    @Parameter(property="xjar.keySize", required=true, defaultValue="128")
    private int keySize;
    @Parameter(property="xjar.ivSize", required=true, defaultValue="128")
    private int ivSize;
    @Parameter(property="xjar.password", required=true)
    private String password;
    @Parameter(property="xjar.sourceDir", required=true, defaultValue="${project.build.directory}")
    private File sourceDir;
    @Parameter(property="xjar.sourceJar", required=true, defaultValue="${project.build.finalName}.jar")
    private String sourceJar;
    @Parameter(property="xjar.targetDir", required=true, defaultValue="${project.build.directory}")
    private File targetDir;
    @Parameter(property="xjar.targetJar", required=true, defaultValue="${project.build.finalName}.xjar")
    private String targetJar;
    @Parameter(property="xjar.includes")
    private String[] includes;
    @Parameter(property="xjar.excludes")
    private String[] excludes;
    @Parameter(property="xjar.deletes")
    private String[] deletes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        String packaging = this.project.getPackaging();
        if (!"jar".equalsIgnoreCase(packaging)) {
            log.info((CharSequence)("Skip for packaging: " + packaging));
            return;
        }
        try {
            XAllEntryFilter filter;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Using algorithm: " + this.algorithm));
                log.debug((CharSequence)("Using key-size: " + this.keySize));
                log.debug((CharSequence)("Using iv-size: " + this.ivSize));
                log.debug((CharSequence)("Using password: " + this.password));
            }
            File src = new File(this.sourceDir, this.sourceJar);
            File dest = new File(this.targetDir, this.targetJar);
            File folder = dest.getParentFile();
            if (!(folder.exists() || folder.mkdirs() || folder.exists())) {
                throw new IOException("could not make directory: " + folder);
            }
            log.info((CharSequence)("Building xjar: " + dest + " for jar: " + src));
            if (XArray.isEmpty(this.includes) && XArray.isEmpty(this.excludes)) {
                filter = null;
                log.info((CharSequence)"Including all resources");
            } else {
                filter = XKit.all();
                if (!XArray.isEmpty(this.includes)) {
                    XAnyEntryFilter including = XKit.any();
                    for (String include : this.includes) {
                        including.mix((XEntryFilter)new XIncludeAntEntryFilter(include));
                        log.info((CharSequence)("Including " + include));
                    }
                    filter.mix((XEntryFilter)including);
                }
                if (!XArray.isEmpty(this.excludes)) {
                    XAllEntryFilter excluding = XKit.all();
                    for (String exclude : this.excludes) {
                        excluding.mix((XEntryFilter)new XExcludeAntEntryFilter(exclude));
                        log.info((CharSequence)("Excluding " + exclude));
                    }
                    filter.mix((XEntryFilter)excluding);
                }
            }
            Build build = this.project.getBuild();
            Map plugins = build.getPluginsAsMap();
            Plugin plugin = (Plugin)plugins.get("org.springframework.boot:spring-boot-maven-plugin");
            if (plugin == null) {
                XJar.encrypt((File)src, (File)dest, (XKey)XKit.key((String)this.algorithm, (int)this.keySize, (int)this.ivSize, (String)this.password), (XEntryFilter)filter);
            } else {
                Object configuration = plugin.getConfiguration();
                if (configuration instanceof Xpp3Dom) {
                    String embeddedLaunchScript;
                    String executable;
                    Xpp3Dom dom = (Xpp3Dom)configuration;
                    Xpp3Dom child = dom.getChild("executable");
                    String string = executable = child != null ? child.getValue() : null;
                    if ("true".equalsIgnoreCase(executable)) {
                        String msg = "Unsupported to build an xjar for an <executable>true</executable> spring boot JAR file, ";
                        msg = msg + "maybe you should upgrade xjar-maven-plugin dependency if it have been supported in the later versions,";
                        msg = msg + "if not, delete <executable>true</executable> or set executable as false for the configuration of spring-boot-maven-plugin.";
                        throw new MojoFailureException(msg);
                    }
                    child = dom.getChild("embeddedLaunchScript");
                    String string2 = embeddedLaunchScript = child != null ? child.getValue() : null;
                    if (embeddedLaunchScript != null) {
                        String msg = "Unsupported to build an xjar for an <embeddedLaunchScript>...</embeddedLaunchScript> spring boot JAR file, ";
                        msg = msg + "maybe you should upgrade xjar-maven-plugin dependency if it have been supported in the later versions,";
                        msg = msg + "if not, delete <embeddedLaunchScript>...</embeddedLaunchScript> for the configuration of spring-boot-maven-plugin.";
                        throw new MojoFailureException(msg);
                    }
                }
                XBoot.encrypt((File)src, (File)dest, (XKey)XKit.key((String)this.algorithm, (int)this.keySize, (int)this.ivSize, (String)this.password), (XEntryFilter)filter);
            }
            File root = this.project.getFile().getParentFile();
            for (int i = 0; this.deletes != null && i < this.deletes.length; ++i) {
                String delete = this.deletes[i];
                File dir = root;
                while (delete.startsWith("../")) {
                    dir = dir.getParentFile() != null ? dir.getParentFile() : dir;
                    delete = delete.substring("../".length());
                }
                log.info((CharSequence)("Deleting file(s) matching pattern: " + dir.getCanonicalPath().replace('\\', '/') + "/" + delete));
                Enumeration resources = Loaders.ant((Loader)Loaders.file((File)dir)).load(delete);
                while (resources.hasMoreElements()) {
                    Resource resource = (Resource)resources.nextElement();
                    URL url = resource.getUrl();
                    String path = url.getPath();
                    File file = new File(path);
                    log.debug((CharSequence)("Deleting file: " + file.getCanonicalPath()));
                    if (file.delete()) continue;
                    log.warn((CharSequence)("Could not delete file: " + file));
                }
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("could not build xjar", e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public void setIvSize(int ivSize) {
        this.ivSize = ivSize;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String getSourceJar() {
        return this.sourceJar;
    }

    public void setSourceJar(String sourceJar) {
        this.sourceJar = sourceJar;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public String getTargetJar() {
        return this.targetJar;
    }

    public void setTargetJar(String targetJar) {
        this.targetJar = targetJar;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getDeletes() {
        return this.deletes;
    }

    public void setDeletes(String[] deletes) {
        this.deletes = deletes;
    }
}

