/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyResultSetBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

abstract class ProxyStatementBase
implements Statement {
    protected Statement delegate;
    protected PooledConnection pCon;
    boolean registered = true;
    private ProxyConnectionBase owner;
    private boolean isClosed;
    private ProxyResultSetBase curRe;
    private int resultOpenCode = 1;
    private ArrayList<ProxyResultSetBase> results;

    public ProxyStatementBase(Statement delegate, PooledConnection pCon) {
        this.delegate = delegate;
        this.pCon = pCon;
        this.owner = pCon.proxyCon;
        this.owner.registerStatement(this);
    }

    final void removeOpenResultSet(ProxyResultSetBase re) {
        if (re == this.curRe) {
            this.curRe = null;
        } else if (this.results != null) {
            this.results.remove(re);
        }
    }

    final void setOpenResultSet(ProxyResultSetBase re) {
        switch (this.resultOpenCode) {
            case 1: {
                if (this.curRe == null || this.curRe.isClosed) break;
                PoolStaticCenter.oclose(this.curRe);
                break;
            }
            case 2: {
                if (this.curRe == null || this.curRe.isClosed) break;
                if (this.results == null) {
                    this.results = new ArrayList(1);
                }
                this.results.add(this.curRe);
                break;
            }
            case 3: {
                if (this.curRe != null && !this.curRe.isClosed) {
                    PoolStaticCenter.oclose(this.curRe);
                }
                if (this.results == null) break;
                int l = this.results.size();
                for (int i = 0; i < l; ++i) {
                    ProxyResultSetBase openRe = this.results.get(i);
                    if (openRe.isClosed) continue;
                    PoolStaticCenter.oclose(openRe);
                }
                this.results.clear();
                break;
            }
        }
        this.curRe = re;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ConnectionClosedException;
        }
        return this.owner;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.curRe != null) {
            PoolStaticCenter.oclose(this.curRe);
        }
        if (this.results != null) {
            int l = this.results.size();
            for (int i = 0; i < l; ++i) {
                PoolStaticCenter.oclose(this.results.get(i));
            }
            this.results.clear();
        }
        try {
            this.delegate.close();
        }
        finally {
            this.delegate = PoolStaticCenter.CLOSED_CSTM;
            if (this.registered) {
                this.owner.unregisterStatement(this);
            }
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.resultOpenCode = current;
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet re = this.delegate.getResultSet();
        if (re == null) {
            return null;
        }
        if (this.curRe != null && this.curRe.containsDelegate(re)) {
            return this.curRe;
        }
        if (this.results != null) {
            for (ProxyResultSetBase resultSetBase : this.results) {
                if (!resultSetBase.containsDelegate(re)) continue;
                return resultSetBase;
            }
        }
        return PoolStaticCenter.createProxyResultSet(re, this, this.pCon);
    }

    @Override
    public void setPoolable(boolean var1) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

