/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class TransactionIsolationLevel {
    public static final String LEVEL_NONE = "NONE";
    public static final String LEVEL_READ_COMMITTED = "READ_COMMITTED";
    public static final String LEVEL_READ_UNCOMMITTED = "READ_UNCOMMITTED";
    public static final String LEVEL_REPEATABLE_READ = "REPEATABLE_READ";
    public static final String LEVEL_SERIALIZABLE = "SERIALIZABLE";
    public static final String TRANS_LEVEL_DESC_LIST = "NONE,READ_COMMITTED,READ_UNCOMMITTED,REPEATABLE_READ,SERIALIZABLE";
    public static final String TRANS_LEVEL_CODE_LIST = String.valueOf(0) + "," + 2 + "," + 1 + "," + 4 + "," + 8;
    private static final Map<String, Integer> IsolationLevelMap = new HashMap<String, Integer>(5);

    public static final int getTransactionIsolationCode(String name) {
        Integer code = IsolationLevelMap.get(name.toUpperCase(Locale.US));
        return code != null ? code : -999;
    }

    public static final boolean isValidTransactionIsolationCode(int code) {
        return IsolationLevelMap.containsValue(code);
    }

    static {
        IsolationLevelMap.put(LEVEL_NONE, 0);
        IsolationLevelMap.put(LEVEL_READ_COMMITTED, 2);
        IsolationLevelMap.put(LEVEL_READ_UNCOMMITTED, 1);
        IsolationLevelMap.put(LEVEL_REPEATABLE_READ, 4);
        IsolationLevelMap.put(LEVEL_SERIALIZABLE, 8);
    }
}

