/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.utils.qrcode.QrcodeUtils;
import com.github.binarywang.wxpay.bean.request.WxEntPayQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxEntPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayAuthcode2OpenidRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.request.WxPayMicropayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderCloseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderReverseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRedpackQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayReportRequest;
import com.github.binarywang.wxpay.bean.request.WxPaySendRedpackRequest;
import com.github.binarywang.wxpay.bean.request.WxPayShorturlRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxEntPayQueryResult;
import com.github.binarywang.wxpay.bean.result.WxEntPayResult;
import com.github.binarywang.wxpay.bean.result.WxPayAuthcode2OpenidResult;
import com.github.binarywang.wxpay.bean.result.WxPayBaseResult;
import com.github.binarywang.wxpay.bean.result.WxPayCommonResult;
import com.github.binarywang.wxpay.bean.result.WxPayMicropayResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderCloseResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderReverseResult;
import com.github.binarywang.wxpay.bean.result.WxPayRedpackQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.bean.result.WxPaySendRedpackResult;
import com.github.binarywang.wxpay.bean.result.WxPayShorturlResult;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayServiceImpl
implements WxPayService {
    private static final String PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxPayConfig config;

    @Override
    public WxPayConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(WxPayConfig config) {
        this.config = config;
    }

    private String getPayBaseUrl() {
        if (this.getConfig().useSandboxForWxPay()) {
            return "https://api.mch.weixin.qq.com/sandboxnew";
        }
        return PAY_BASE_URL;
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/refund";
        String responseContent = this.postWithKey(url, request.toXML());
        WxPayRefundResult result = WxPayBaseResult.fromXML(responseContent, WxPayRefundResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayRefundQueryResult refundQuery(String transactionId, String outTradeNo, String outRefundNo, String refundId) throws WxErrorException {
        WxPayRefundQueryRequest request = new WxPayRefundQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setOutRefundNo(StringUtils.trimToNull((String)outRefundNo));
        request.setRefundId(StringUtils.trimToNull((String)refundId));
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/refundquery";
        String responseContent = this.post(url, request.toXML());
        WxPayRefundQueryResult result = WxPayBaseResult.fromXML(responseContent, WxPayRefundQueryResult.class);
        result.composeRefundRecords();
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderNotifyResult getOrderNotifyResult(String xmlData) throws WxErrorException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u8be6\u7ec6\uff1a{}", (Object)xmlData);
            WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult(this);
            return result;
        }
        catch (WxErrorException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u53d1\u751f\u5f02\u5e38" + e.getMessage()).build());
        }
    }

    @Override
    public WxPaySendRedpackResult sendRedpack(WxPaySendRedpackRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendredpack";
        if (request.getAmtType() != null) {
            url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendgroupredpack";
        }
        String responseContent = this.postWithKey(url, request.toXML());
        WxPaySendRedpackResult result = WxPayBaseResult.fromXML(responseContent, WxPaySendRedpackResult.class);
        return result;
    }

    @Override
    public WxPayRedpackQueryResult queryRedpack(String mchBillNo) throws WxErrorException {
        WxPayRedpackQueryRequest request = new WxPayRedpackQueryRequest();
        request.setMchBillNo(mchBillNo);
        request.setBillType("MCHT");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gethbinfo";
        String responseContent = this.postWithKey(url, request.toXML());
        WxPayRedpackQueryResult result = WxPayBaseResult.fromXML(responseContent, WxPayRedpackQueryResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxErrorException {
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/orderquery";
        String responseContent = this.post(url, request.toXML());
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u54cd\u5e94\u7ed3\u679c").build());
        }
        WxPayOrderQueryResult result = WxPayBaseResult.fromXML(responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/closeorder";
        String responseContent = this.post(url, request.toXML());
        WxPayOrderCloseResult result = WxPayBaseResult.fromXML(responseContent, WxPayOrderCloseResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/unifiedorder";
        String responseContent = this.post(url, request.toXML());
        WxPayUnifiedOrderResult result = WxPayBaseResult.fromXML(responseContent, WxPayUnifiedOrderResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public Map<String, String> getPayInfo(WxPayUnifiedOrderRequest request) throws WxErrorException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        payInfo.put("appId", this.getConfig().getAppId());
        payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        payInfo.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        payInfo.put("package", "prepay_id=" + prepayId);
        payInfo.put("signType", "MD5");
        if ("NATIVE".equals(request.getTradeType())) {
            payInfo.put("codeUrl", unifiedOrderResult.getCodeURL());
        }
        payInfo.put("paySign", SignUtils.createSign(payInfo, this.getConfig().getMchKey()));
        return payInfo;
    }

    @Override
    public WxEntPayResult entPay(WxEntPayRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/promotion/transfers";
        String responseContent = this.postWithKey(url, request.toXML());
        WxEntPayResult result = WxPayBaseResult.fromXML(responseContent, WxEntPayResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxEntPayQueryResult queryEntPay(String partnerTradeNo) throws WxErrorException {
        WxEntPayQueryRequest request = new WxEntPayQueryRequest();
        request.setPartnerTradeNo(partnerTradeNo);
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gettransferinfo";
        String responseContent = this.postWithKey(url, request.toXML());
        WxEntPayQueryResult result = WxPayBaseResult.fromXML(responseContent, WxEntPayQueryResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public byte[] createScanPayQrcodeMode1(String productId, File logoFile, Integer sideLength) {
        String content = this.createScanPayQrcodeMode1(productId);
        return this.createQrcode(content, logoFile, sideLength);
    }

    @Override
    public String createScanPayQrcodeMode1(String productId) {
        StringBuilder codeUrl = new StringBuilder("weixin://wxpay/bizpayurl?");
        HashMap params = Maps.newHashMap();
        params.put("appid", this.getConfig().getAppId());
        params.put("mch_id", this.getConfig().getMchId());
        params.put("product_id", productId);
        params.put("time_stamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = SignUtils.createSign(params, this.getConfig().getMchKey());
        params.put("sign", sign);
        for (String key : params.keySet()) {
            codeUrl.append(key + "=" + (String)params.get(key) + "&");
        }
        String content = codeUrl.toString().substring(0, codeUrl.length() - 1);
        this.log.debug("\u626b\u7801\u652f\u4ed8\u6a21\u5f0f\u4e00\u751f\u6210\u4e8c\u7ef4\u7801\u7684URL:{}", (Object)content);
        return content;
    }

    @Override
    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        return this.createQrcode(codeUrl, logoFile, sideLength);
    }

    private byte[] createQrcode(String content, File logoFile, Integer sideLength) {
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)content, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)content, (int)sideLength, (File)logoFile);
    }

    @Override
    public void report(WxPayReportRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/payitil/report";
        String responseContent = this.post(url, request.toXML());
        WxPayCommonResult result = WxPayBaseResult.fromXML(responseContent, WxPayCommonResult.class);
        result.checkResult(this);
    }

    @Override
    public File downloadBill(String billDate, String billType, String tarType, String deviceInfo) throws WxErrorException {
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillType(billType);
        request.setBillDate(billDate);
        request.setTarType(tarType);
        request.setDeviceInfo(deviceInfo);
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadbill";
        String responseContent = this.post(url, request.toXML());
        WxPayCommonResult result = WxPayBaseResult.fromXML(responseContent, WxPayCommonResult.class);
        result.checkResult(this);
        return null;
    }

    @Override
    public WxPayMicropayResult micropay(WxPayMicropayRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/micropay";
        String responseContent = this.post(url, request.toXML());
        WxPayMicropayResult result = WxPayBaseResult.fromXML(responseContent, WxPayMicropayResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderReverseResult reverseOrder(WxPayOrderReverseRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/reverse";
        String responseContent = this.postWithKey(url, request.toXML());
        WxPayOrderReverseResult result = WxPayBaseResult.fromXML(responseContent, WxPayOrderReverseResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public String shorturl(WxPayShorturlRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/shorturl";
        String responseContent = this.post(url, request.toXML());
        WxPayShorturlResult result = WxPayBaseResult.fromXML(responseContent, WxPayShorturlResult.class);
        result.checkResult(this);
        return result.getShortUrl();
    }

    @Override
    public String shorturl(String longUrl) throws WxErrorException {
        return this.shorturl(new WxPayShorturlRequest(longUrl));
    }

    @Override
    public String authcode2Openid(WxPayAuthcode2OpenidRequest request) throws WxErrorException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/authcodetoopenid";
        String responseContent = this.post(url, request.toXML());
        WxPayAuthcode2OpenidResult result = WxPayBaseResult.fromXML(responseContent, WxPayAuthcode2OpenidResult.class);
        result.checkResult(this);
        return result.getOpenid();
    }

    @Override
    public String authcode2Openid(String authCode) throws WxErrorException {
        return this.authcode2Openid(new WxPayAuthcode2OpenidRequest(authCode));
    }

    private String post(String url, String xmlParam) {
        String requestString = xmlParam;
        try {
            requestString = new String(xmlParam.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpRequest request = (HttpRequest)HttpRequest.post((String)url).body(requestString);
        HttpResponse response = request.send();
        String responseString = null;
        try {
            responseString = new String(response.bodyText().getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.log.debug("\n[URL]: {}\n[PARAMS]: {}\n[RESPONSE]: {}", new Object[]{url, xmlParam, responseString});
        return responseString;
    }

    /*
     * Exception decompiling
     */
    private String postWithKey(String url, String requestStr) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

