/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.WxPayBaseRequest;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayOrderReverseRequest
extends WxPayBaseRequest {
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="sign_type")
    private String signType;

    private WxPayOrderReverseRequest(Builder builder) {
        this.setTransactionId(builder.transactionId);
        this.setAppid(builder.appid);
        this.setOutTradeNo(builder.outTradeNo);
        this.setMchId(builder.mchId);
        this.setSignType(builder.signType);
        this.setSubAppId(builder.subAppId);
        this.setSubMchId(builder.subMchId);
        this.setNonceStr(builder.nonceStr);
        this.setSign(builder.sign);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    @Override
    protected void checkConstraints() {
        if (StringUtils.isBlank((CharSequence)this.transactionId) && StringUtils.isBlank((CharSequence)this.outTradeNo)) {
            throw new IllegalArgumentException("transaction_id \u548c out_trade_no\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    public static final class Builder {
        private String transactionId;
        private String appid;
        private String outTradeNo;
        private String mchId;
        private String signType;
        private String subAppId;
        private String subMchId;
        private String nonceStr;
        private String sign;

        private Builder() {
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public Builder mchId(String mchId) {
            this.mchId = mchId;
            return this;
        }

        public Builder signType(String signType) {
            this.signType = signType;
            return this;
        }

        public Builder subAppId(String subAppId) {
            this.subAppId = subAppId;
            return this;
        }

        public Builder subMchId(String subMchId) {
            this.subMchId = subMchId;
            return this;
        }

        public Builder nonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
            return this;
        }

        public Builder sign(String sign) {
            this.sign = sign;
            return this;
        }

        public WxPayOrderReverseRequest build() {
            return new WxPayOrderReverseRequest(this);
        }
    }
}

