/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpDeviceService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpMenuServiceImpl;
import me.chanjar.weixin.mp.bean.device.TransMsgResp;
import me.chanjar.weixin.mp.bean.device.WxDeviceAuthorize;
import me.chanjar.weixin.mp.bean.device.WxDeviceAuthorizeResult;
import me.chanjar.weixin.mp.bean.device.WxDeviceBind;
import me.chanjar.weixin.mp.bean.device.WxDeviceBindResult;
import me.chanjar.weixin.mp.bean.device.WxDeviceMsg;
import me.chanjar.weixin.mp.bean.device.WxDeviceQrCodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpDeviceServiceImpl
implements WxMpDeviceService {
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/device";
    private static Logger log = LoggerFactory.getLogger(WxMpMenuServiceImpl.class);
    private WxMpService wxMpService;

    WxMpDeviceServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public TransMsgResp transMsg(WxDeviceMsg msg) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/transmsg";
        String response = this.wxMpService.post(url, msg.toJson());
        return TransMsgResp.fromJson(response);
    }

    @Override
    public WxDeviceQrCodeResult getQrCode(String productId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/getqrcode";
        String response = this.wxMpService.get(url, "product_id=" + productId);
        return WxDeviceQrCodeResult.fromJson(response);
    }

    @Override
    public WxDeviceAuthorizeResult authorize(WxDeviceAuthorize wxDeviceAuthorize) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/authorize_device";
        String response = this.wxMpService.post(url, wxDeviceAuthorize.toJson());
        return WxDeviceAuthorizeResult.fromJson(response);
    }

    @Override
    public WxDeviceBindResult bind(WxDeviceBind wxDeviceBind) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/bind";
        String response = this.wxMpService.post(url, wxDeviceBind.toJson());
        return WxDeviceBindResult.fromJson(response);
    }

    @Override
    public WxDeviceBindResult compelBind(WxDeviceBind wxDeviceBind) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/compel_bind";
        String response = this.wxMpService.post(url, wxDeviceBind.toJson());
        return WxDeviceBindResult.fromJson(response);
    }

    @Override
    public WxDeviceBindResult unbind(WxDeviceBind wxDeviceBind) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/unbind?";
        String response = this.wxMpService.post(url, wxDeviceBind.toJson());
        return WxDeviceBindResult.fromJson(response);
    }

    @Override
    public WxDeviceBindResult compelUnbind(WxDeviceBind wxDeviceBind) throws WxErrorException {
        String url = "https://api.weixin.qq.com/device/compel_unbind?";
        String response = this.wxMpService.post(url, wxDeviceBind.toJson());
        return WxDeviceBindResult.fromJson(response);
    }
}

