/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.locks;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisTemplateSimpleDistributedLock
implements Lock {
    private final StringRedisTemplate redisTemplate;
    private final String key;
    private final int leaseMilliseconds;
    private final ThreadLocal<String> valueThreadLocal = new ThreadLocal();

    public RedisTemplateSimpleDistributedLock(StringRedisTemplate redisTemplate, int leaseMilliseconds) {
        this(redisTemplate, "lock:" + UUID.randomUUID().toString(), leaseMilliseconds);
    }

    public RedisTemplateSimpleDistributedLock(StringRedisTemplate redisTemplate, String key, int leaseMilliseconds) {
        if (leaseMilliseconds <= 0) {
            throw new IllegalArgumentException("Parameter 'leaseMilliseconds' must grate then 0: " + leaseMilliseconds);
        }
        this.redisTemplate = redisTemplate;
        this.key = key;
        this.leaseMilliseconds = leaseMilliseconds;
    }

    @Override
    public void lock() {
        while (!this.tryLock()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        while (!this.tryLock()) {
            Thread.sleep(1000L);
        }
    }

    @Override
    public boolean tryLock() {
        Boolean lockAcquired;
        String value = this.valueThreadLocal.get();
        if (value == null || value.isEmpty()) {
            value = UUID.randomUUID().toString();
            this.valueThreadLocal.set(value);
        }
        if (Boolean.TRUE.equals(lockAcquired = this.redisTemplate.opsForValue().setIfAbsent((Object)this.key, (Object)value, (long)this.leaseMilliseconds, TimeUnit.MILLISECONDS))) {
            return true;
        }
        String currentValue = (String)this.redisTemplate.opsForValue().get((Object)this.key);
        return value.equals(currentValue);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        long sleep;
        boolean locked = this.tryLock();
        for (long waitMs = unit.toMillis(time); !locked && waitMs > 0L; waitMs -= sleep) {
            sleep = waitMs < 1000L ? waitMs : 1000L;
            Thread.sleep(sleep);
            locked = this.tryLock();
        }
        return locked;
    }

    @Override
    public void unlock() {
        if (this.valueThreadLocal.get() != null) {
            DefaultRedisScript script = new DefaultRedisScript("if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end", Long.class);
            this.redisTemplate.execute((RedisScript)script, Collections.singletonList(this.key), new Object[]{this.valueThreadLocal.get()});
            this.valueThreadLocal.remove();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public String getLockSecretValue() {
        return this.valueThreadLocal.get();
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getKey() {
        return this.key;
    }

    public int getLeaseMilliseconds() {
        return this.leaseMilliseconds;
    }
}

