/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts.json;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.json.GsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionUtil {
    private OptionUtil() {
    }

    public static String exportToHtml(Option option) {
        String folderPath = System.getProperty("java.io.tmpdir");
        return OptionUtil.exportToHtml(option, folderPath);
    }

    public static String exportToHtml(Option option, String folderPath) {
        String fileName = "ECharts-" + System.currentTimeMillis() + ".html";
        return OptionUtil.exportToHtml(option, folderPath, fileName);
    }

    private static String getFolderPath(String folderPath) {
        File folder = new File(folderPath);
        if (folder.exists() && folder.isFile()) {
            String tempPath = folder.getParent();
            folder = new File(tempPath);
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(Option option) {
        String optionStr = GsonUtil.format(option);
        InputStream is = null;
        InputStreamReader iReader = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            is = OptionUtil.class.getResourceAsStream("/template");
            iReader = new InputStreamReader(is, "UTF-8");
            bufferedReader = new BufferedReader(iReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains("##option##")) {
                    line = line.replace("##option##", optionStr);
                }
                lines.add(line);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exportToHtml(Option option, String folderPath, String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return OptionUtil.exportToHtml(option, folderPath);
        }
        Writer writer = null;
        List<String> lines = OptionUtil.readLines(option);
        File html = new File(OptionUtil.getFolderPath(folderPath) + "/" + fileName);
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(html), "UTF-8");
            for (String l : lines) {
                writer.write(l + "\n");
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            return html.getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String browse(Option option) {
        String htmlPath = OptionUtil.exportToHtml(option);
        try {
            OptionUtil.browse(htmlPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return htmlPath;
    }

    public static void browse(String url) throws Exception {
        String osName = System.getProperty("os.name", "");
        if (osName.startsWith("Mac OS")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }
}

