/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts.series;

import com.github.abel533.echarts.code.Layout;
import com.github.abel533.echarts.code.Roam;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.series.Series;
import com.github.abel533.echarts.series.force.Category;
import com.github.abel533.echarts.series.force.Link;
import com.github.abel533.echarts.series.force.Node;
import com.github.abel533.echarts.series.other.Force;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends Series<Graph> {
    private Layout layout;
    private Force force;
    private Object roam;
    private Double nodeScaleRatio;
    private List<Category> categories;
    private List nodes;
    private List<Link> links;
    private List<Link> edges;
    private Object center;
    private Object size;
    private Boolean preventOverlap;
    private Object coolDown;
    private Boolean ratioScaling;
    private Integer minRadius;
    private Integer maxRadius;
    private Object linkSymbol;
    private Integer linkSymbolSize;
    private Double scaling;
    private Double gravity;
    private Boolean draggable;
    private Boolean large;
    private Boolean useWorker;
    private Integer steps;

    public Graph() {
        this.type(SeriesType.graph);
    }

    public Graph(String name) {
        super(name);
        this.type(SeriesType.graph);
    }

    public Graph(String name, Layout layout) {
        super(name);
        this.type(SeriesType.graph);
        this.layout = layout;
    }

    public Layout layout() {
        return this.layout;
    }

    public Graph layout(Layout layout) {
        this.layout = layout;
        return this;
    }

    public Force force() {
        if (this.force == null) {
            this.force = new Force();
        }
        return this.force;
    }

    public Graph force(Force force) {
        this.force = force;
        return this;
    }

    public Double nodeScaleRatio() {
        return this.nodeScaleRatio;
    }

    public Graph nodeScaleRatio(Double nodeScaleRatio) {
        this.nodeScaleRatio = nodeScaleRatio;
        return this;
    }

    public Object coolDown() {
        return this.coolDown;
    }

    public Graph coolDown(Object coolDown) {
        this.coolDown = coolDown;
        return this;
    }

    public Boolean ratioScaling() {
        return this.ratioScaling;
    }

    public Graph ratioScaling(Boolean ratioScaling) {
        this.ratioScaling = ratioScaling;
        return this;
    }

    public Boolean preventOverlap() {
        return this.preventOverlap;
    }

    public Graph preventOverlap(Boolean preventOverlap) {
        this.preventOverlap = preventOverlap;
        return this;
    }

    public Graph categories(List<Category> categories) {
        this.categories = categories;
        return this;
    }

    public Graph nodes(List nodes) {
        this.nodes = nodes;
        return this;
    }

    public Graph links(List<Link> links) {
        this.links = links;
        return this;
    }

    public Graph edges(List<Link> edges) {
        this.edges = edges;
        return this;
    }

    public List<Category> categories() {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        return this.categories;
    }

    public Graph categories(Category ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        this.categories().addAll(Arrays.asList(values));
        return this;
    }

    public Graph categories(String ... names) {
        if (names == null || names.length == 0) {
            return this;
        }
        for (String name : names) {
            this.categories().add(new Category(name));
        }
        return this;
    }

    public Graph categories(Object ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        for (Object value : values) {
            if (value instanceof String) {
                this.categories().add(new Category((String)value));
                continue;
            }
            if (!(value instanceof Category)) continue;
            this.categories().add((Category)value);
        }
        return this;
    }

    public List<Node> nodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
        }
        return this.nodes;
    }

    public Graph nodes(Node ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        this.nodes().addAll(Arrays.asList(values));
        return this;
    }

    public List<Link> links() {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        return this.links;
    }

    public Graph links(Link ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        this.links().addAll(Arrays.asList(values));
        return this;
    }

    public List<Link> edges() {
        if (this.edges == null) {
            this.edges = new ArrayList<Link>();
        }
        return this.edges;
    }

    public Graph edges(Link ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        this.edges().addAll(Arrays.asList(values));
        return this;
    }

    public Object center() {
        return this.center;
    }

    public Graph center(Object center) {
        this.center = center;
        return this;
    }

    public Object size() {
        return this.size;
    }

    public Graph size(Object size) {
        this.size = size;
        return this;
    }

    public Integer minRadius() {
        return this.minRadius;
    }

    public Graph minRadius(Integer minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    public Integer maxRadius() {
        return this.maxRadius;
    }

    public Graph maxRadius(Integer maxRadius) {
        this.maxRadius = maxRadius;
        return this;
    }

    public Object linkSymbol() {
        return this.linkSymbol;
    }

    public Graph linkSymbol(Symbol linkSymbol) {
        this.linkSymbol = linkSymbol;
        return this;
    }

    public Graph linkSymbol(String linkSymbol) {
        this.linkSymbol = linkSymbol;
        return this;
    }

    public Integer linkSymbolSize() {
        return this.linkSymbolSize;
    }

    public Graph linkSymbolSize(Integer linkSymbolSize) {
        this.linkSymbolSize = linkSymbolSize;
        return this;
    }

    public Double scaling() {
        return this.scaling;
    }

    public Graph scaling(Double scaling) {
        this.scaling = scaling;
        return this;
    }

    public Double gravity() {
        return this.gravity;
    }

    public Graph gravity(Double gravity) {
        this.gravity = gravity;
        return this;
    }

    public Boolean draggable() {
        return this.draggable;
    }

    public Graph draggable(Boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public Boolean large() {
        return this.large;
    }

    public Graph large(Boolean large) {
        this.large = large;
        return this;
    }

    public Boolean useWorker() {
        return this.useWorker;
    }

    public Graph useWorker(Boolean useWorker) {
        this.useWorker = useWorker;
        return this;
    }

    public Integer steps() {
        return this.steps;
    }

    public Graph steps(Integer steps) {
        this.steps = steps;
        return this;
    }

    public Object roam() {
        return this.roam;
    }

    public Graph roam(Boolean roam) {
        this.roam = roam;
        return this;
    }

    public Graph roam(Roam roam) {
        this.roam = roam;
        return this;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public List getNodes() {
        return this.nodes;
    }

    public void setNodes(List nodes) {
        this.nodes = nodes;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public List<Link> getEdges() {
        return this.edges;
    }

    public void setEdges(List<Link> edges) {
        this.edges = edges;
    }

    public Object getCenter() {
        return this.center;
    }

    public void setCenter(Object center) {
        this.center = center;
    }

    public Object getSize() {
        return this.size;
    }

    public void setSize(Object size) {
        this.size = size;
    }

    public Integer getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(Integer minRadius) {
        this.minRadius = minRadius;
    }

    public Integer getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(Integer maxRadius) {
        this.maxRadius = maxRadius;
    }

    public Object getLinkSymbol() {
        return this.linkSymbol;
    }

    public void setLinkSymbol(Object linkSymbol) {
        this.linkSymbol = linkSymbol;
    }

    public Integer getLinkSymbolSize() {
        return this.linkSymbolSize;
    }

    public void setLinkSymbolSize(Integer linkSymbolSize) {
        this.linkSymbolSize = linkSymbolSize;
    }

    public Double getScaling() {
        return this.scaling;
    }

    public void setScaling(Double scaling) {
        this.scaling = scaling;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Boolean getDraggable() {
        return this.draggable;
    }

    public void setDraggable(Boolean draggable) {
        this.draggable = draggable;
    }

    public Boolean getLarge() {
        return this.large;
    }

    public void setLarge(Boolean large) {
        this.large = large;
    }

    public Boolean getUseWorker() {
        return this.useWorker;
    }

    public void setUseWorker(Boolean useWorker) {
        this.useWorker = useWorker;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public Object getCoolDown() {
        return this.coolDown;
    }

    public void setCoolDown(Object coolDown) {
        this.coolDown = coolDown;
    }

    public Boolean getRatioScaling() {
        return this.ratioScaling;
    }

    public void setRatioScaling(Boolean ratioScaling) {
        this.ratioScaling = ratioScaling;
    }

    public Boolean getPreventOverlap() {
        return this.preventOverlap;
    }

    public void setPreventOverlap(Boolean preventOverlap) {
        this.preventOverlap = preventOverlap;
    }

    public Object getRoam() {
        return this.roam;
    }

    public void setRoam(Object roam) {
        this.roam = roam;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Force getForce() {
        return this.force;
    }

    public void setForce(Force force) {
        this.force = force;
    }

    public Double getNodeScaleRatio() {
        return this.nodeScaleRatio;
    }

    public void setNodeScaleRatio(Double nodeScaleRatio) {
        this.nodeScaleRatio = nodeScaleRatio;
    }
}

