/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

public class SizeScaler {
    private static final int ROUNDING_VALUE = 64;
    private final float scaleFactor;

    public SizeScaler(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    Size scale(int width, int height) {
        int nonRoundedScaledWidth = this.downscaleSize(width);
        int scaledWidth = this.roundSize(nonRoundedScaledWidth);
        float roundingScaleFactor = (float)width / (float)scaledWidth;
        int scaledHeight = (int)Math.ceil((float)height / roundingScaleFactor);
        return new Size(scaledWidth, scaledHeight, roundingScaleFactor);
    }

    boolean isZeroSized(int measuredWidth, int measuredHeight) {
        return this.downscaleSize(measuredHeight) == 0 || this.downscaleSize(measuredWidth) == 0;
    }

    private int roundSize(int value) {
        if (value % 64 == 0) {
            return value;
        }
        return value - value % 64 + 64;
    }

    private int downscaleSize(float value) {
        return (int)Math.ceil(value / this.scaleFactor);
    }

    static class Size {
        final int width;
        final int height;
        final float scaleFactor;

        Size(int width, int height, float scaleFactor) {
            this.width = width;
            this.height = height;
            this.scaleFactor = scaleFactor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Size size = (Size)o;
            if (this.width != size.width) {
                return false;
            }
            if (this.height != size.height) {
                return false;
            }
            return Float.compare(size.scaleFactor, this.scaleFactor) == 0;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + (this.scaleFactor != 0.0f ? Float.floatToIntBits(this.scaleFactor) : 0);
            return result;
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + ", scaleFactor=" + this.scaleFactor + '}';
        }
    }
}

