/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.utils;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.util.JdbcConstants;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.utils.DESUtils;
import com.gccloud.dataset.vo.DbDataVO;
import com.google.common.collect.Lists;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    private static final Integer STORED_PROCEDURE_MAX_HINT = 2000;

    public static DbDataVO call(String procedure, DatasourceEntity datasource, Integer current, Integer size) {
        Connection connection = DBUtils.getConnection(datasource);
        if (connection == null) {
            throw new GlobalException("\u6570\u636e\u6e90\u8fde\u63a5\u5efa\u7acb\u5931\u8d25");
        }
        DbDataVO dataVO = new DbDataVO();
        ArrayList data = Lists.newArrayList();
        ArrayList structure = Lists.newArrayList();
        dataVO.setData(data);
        dataVO.setStructure(structure);
        try {
            int start;
            boolean isPage;
            CallableStatement proc = connection.prepareCall(procedure, 1004, 1007);
            if ("oracle".equalsIgnoreCase(datasource.getSourceType())) {
                proc.registerOutParameter(1, -10);
            }
            if ("postgresql".equalsIgnoreCase(datasource.getSourceType())) {
                proc.registerOutParameter(1, 1111);
            }
            proc.executeQuery();
            ResultSet rs = "oracle".equalsIgnoreCase(datasource.getSourceType()) || "postgresql".equals(datasource.getSourceType()) ? (ResultSet)proc.getObject(1) : proc.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                ConcurrentHashMap<String, String> structureMap = new ConcurrentHashMap<String, String>();
                structureMap.put("fieldName", metaData.getColumnName(i + 1));
                structureMap.put("fieldType", metaData.getColumnTypeName(i + 1));
                structure.add(structureMap);
            }
            int totalSize = 0;
            int resultSetType = rs.getType();
            boolean isScroll = resultSetType == 1004 || resultSetType == 1005;
            boolean bl = isPage = current != null && size != null;
            if (!isPage) {
                Object map2;
                int resultCount = 0;
                while (rs.next() && ++resultCount <= STORED_PROCEDURE_MAX_HINT) {
                    map2 = new HashMap(columnCount);
                    for (int i = 1; i <= columnCount; ++i) {
                        map2.put(metaData.getColumnName(i), rs.getObject(i));
                    }
                    data.add(map2);
                }
                map2 = dataVO;
                return map2;
            }
            if (!isScroll) {
                Object map;
                PageVO pageData = new PageVO();
                pageData.setTotalCount(0L);
                pageData.setTotalPage(0L);
                pageData.setCurrent((long)current.intValue());
                pageData.setSize((long)size.intValue());
                dataVO.setPageData((PageVO<Map<String, Object>>)pageData);
                if (current * size > STORED_PROCEDURE_MAX_HINT) {
                    log.warn("\u5206\u9875\u6570\u636e\u4f4d\u7f6e\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff0c\u65e0\u6cd5\u5904\u7406:" + STORED_PROCEDURE_MAX_HINT);
                    DbDataVO map2 = dataVO;
                    return map2;
                }
                int resultCount = 0;
                int start2 = (current - 1) * size;
                while (rs.next() && ++resultCount <= STORED_PROCEDURE_MAX_HINT) {
                    if (resultCount < start2 || resultCount == start2 + size) continue;
                    map = new HashMap(columnCount);
                    for (int i = 1; i <= columnCount; ++i) {
                        map.put(metaData.getColumnName(i), rs.getObject(i));
                    }
                    data.add(map);
                }
                totalSize = resultCount;
                pageData.setTotalCount((long)totalSize);
                pageData.setTotalPage(totalSize % size == 0 ? (long)(totalSize / size) : (long)(totalSize / size + 1));
                pageData.setList((List)data);
                map = dataVO;
                return map;
            }
            rs.last();
            totalSize = rs.getRow();
            rs.beforeFirst();
            if (size > STORED_PROCEDURE_MAX_HINT) {
                size = STORED_PROCEDURE_MAX_HINT;
                log.warn("\u5206\u9875\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff0c\u4f7f\u7528\u6700\u5927\u9650\u5236\u6570:" + STORED_PROCEDURE_MAX_HINT);
            }
            if ((start = (current - 1) * size) > totalSize) {
                PageVO pageData = new PageVO();
                pageData.setTotalCount((long)totalSize);
                pageData.setTotalPage(totalSize % size == 0 ? (long)(totalSize / size) : (long)(totalSize / size + 1));
                pageData.setCurrent((long)current.intValue());
                pageData.setSize((long)size.intValue());
                dataVO.setPageData((PageVO<Map<String, Object>>)pageData);
                DbDataVO start2 = dataVO;
                return start2;
            }
            rs.absolute((current - 1) * size);
            int resultCount = 0;
            while (rs.next() && ++resultCount <= size) {
                HashMap<String, Object> map = new HashMap<String, Object>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    map.put(metaData.getColumnName(i), rs.getObject(i));
                }
                data.add(map);
            }
            PageVO pageData = new PageVO();
            pageData.setTotalCount((long)totalSize);
            pageData.setTotalPage(totalSize % size == 0 ? (long)(totalSize / size) : (long)(totalSize / size + 1));
            pageData.setCurrent((long)current.intValue());
            pageData.setSize((long)size.intValue());
            pageData.setList((List)data);
            dataVO.setPageData((PageVO<Map<String, Object>>)pageData);
        }
        catch (Exception ex) {
            log.error("\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5931\u8d25 \uff0c{}", (Object)ex.getMessage());
            log.error(ExceptionUtils.getStackTrace((Throwable)ex));
            throw new GlobalException(ex.getMessage());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error("\u6570\u636e\u6e90\u8fde\u63a5\u5173\u95ed\u5f02\u5e38,{}", (Object)e.getMessage());
            }
        }
        return dataVO;
    }

    public static DbDataVO getSqlValue(String sql, DatasourceEntity datasource) {
        log.info("\u6267\u884csql:" + sql);
        boolean onlySelectSql = DBUtils.onlySelectSql(sql, datasource.getSourceType());
        if (!onlySelectSql) {
            throw new GlobalException("\u53ea\u652f\u6301select\u8bed\u53e5");
        }
        return DBUtils.executeSql(sql, datasource);
    }

    public static DbDataVO getSqlValueWithoutCheck(String sql, DatasourceEntity datasource) {
        log.info("\u6267\u884csql:" + sql);
        return DBUtils.executeSql(sql, datasource);
    }

    public static DbDataVO executeSql(String sql, DatasourceEntity datasource) {
        Connection connection = DBUtils.getConnection(datasource);
        if (connection == null) {
            throw new GlobalException("\u6570\u636e\u6e90\u8fde\u63a5\u5efa\u7acb\u5931\u8d25");
        }
        DbDataVO dataVO = new DbDataVO();
        ArrayList data = Lists.newArrayList();
        ArrayList structure = Lists.newArrayList();
        dataVO.setData(data);
        dataVO.setStructure(structure);
        try {
            PreparedStatement ps = connection.prepareStatement(sql);
            ResultSet clickRs = ps.executeQuery();
            ResultSetMetaData metaData = clickRs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                ConcurrentHashMap<String, String> structureMap = new ConcurrentHashMap<String, String>();
                structureMap.put("fieldName", metaData.getColumnName(i));
                structureMap.put("fieldType", metaData.getColumnTypeName(i));
                structure.add(structureMap);
            }
            while (clickRs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    map.put(metaData.getColumnName(i), clickRs.getObject(i));
                }
                data.add(map);
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u67e5\u8be2\u5931\u8d25:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u6570\u636e\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error("\u6570\u636e\u6e90\u8fde\u63a5\u5173\u95ed\u5f02\u5e38,{}", (Object)e.getMessage());
            }
        }
        return dataVO;
    }

    public static Connection getConnection(DatasourceEntity datasource) {
        Connection connection;
        try {
            Class.forName(datasource.getDriverClassName());
            connection = datasource.getUsername() != null && datasource.getPassword() != null ? DriverManager.getConnection(datasource.getUrl(), datasource.getUsername(), DESUtils.getDecryptString(datasource.getPassword())) : DriverManager.getConnection(datasource.getUrl());
        }
        catch (SQLSyntaxErrorException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException(DBUtils.getExceptionMessage(e.getMessage()));
        }
        return connection;
    }

    private static String getExceptionMessage(String message) {
        if (message.contains("Connection refused")) {
            return "\u6570\u636e\u6e90\u8fde\u63a5\u8d85\u65f6";
        }
        if (message.contains("password")) {
            return "\u6570\u636e\u6e90\u7528\u6237\u540d\u6216\u5bc6\u7801\u6709\u8bef";
        }
        if (message.contains("Database")) {
            return "\u6570\u636e\u5e93\u4e0d\u5b58\u5728";
        }
        if (message.contains("driver")) {
            return "\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u6709\u8bef";
        }
        if (message.contains("TCP/IP connection")) {
            return "\u6570\u636e\u6e90\u8fde\u63a5\u8d85\u65f6";
        }
        if (message.contains("does not exist")) {
            return "\u6570\u636e\u5e93\u4e0d\u5b58\u5728";
        }
        return message;
    }

    public static String updateParamsConfig(String sql, List<DatasetParamDTO> params) {
        if (CollectionUtils.isEmpty(params)) {
            return sql;
        }
        for (DatasetParamDTO param : params) {
            if (null == param.getStatus() || !DatasetConstant.SqlParamsStatus.VARIABLE.equals(param.getStatus())) continue;
            if (sql.contains("<" + param.getName() + ">") && sql.contains("</" + param.getName() + ">")) {
                if (StringUtils.isEmpty((CharSequence)param.getValue())) {
                    sql = DBUtils.subRangeString(sql, "<" + param.getName() + ">", "</" + param.getName() + ">");
                    continue;
                }
                sql = sql.replaceAll("<" + param.getName() + ">", "").replaceAll("</" + param.getName() + ">", "");
                sql = DBUtils.parameterReplace(param, sql);
                continue;
            }
            sql = DBUtils.parameterReplace(param, sql);
        }
        return sql;
    }

    public static String parameterReplace(DatasetParamDTO param, String sql) {
        sql = "String".equals(param.getType()) || "Date".equals(param.getType()) ? sql.replaceAll("\\$\\{" + param.getName() + "\\}", "'" + param.getValue() + "'") : sql.replaceAll("\\$\\{" + param.getName() + "\\}", param.getValue());
        return sql;
    }

    public static String subRangeString(String body, String str1, String str2) {
        int index1;
        while ((index1 = body.indexOf(str1)) != -1) {
            int index2 = body.indexOf(str2, index1);
            if (index2 != -1) {
                body = body.substring(0, index1) + body.substring(index2 + str2.length());
                continue;
            }
            return body;
        }
        return body;
    }

    public static List<String> getTableNames(String sql, String datasourceType) {
        DbType jdbcType = DBUtils.translateDbType(datasourceType);
        if (jdbcType == null) {
            return null;
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            List stmts = SQLUtils.parseStatements((String)sql, (DbType)jdbcType);
            String database = "";
            for (SQLStatement stmt : stmts) {
                SchemaStatVisitor statVisitor = SQLUtils.createSchemaStatVisitor((DbType)jdbcType);
                if (stmt instanceof SQLUseStatement) {
                    database = ((SQLUseStatement)stmt).getDatabase().getSimpleName().toUpperCase();
                }
                stmt.accept((SQLASTVisitor)statVisitor);
                Map tables = statVisitor.getTables();
                if (tables == null) continue;
                String db = database;
                tables.forEach((tableName, stat) -> {
                    if (stat.getSelectCount() > 0) {
                        String from = tableName.getName();
                        tableNames.add(from);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6sql\u8bed\u53e5\u4e2d\u7684\u8868\u540d\u5f02\u5e38");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return tableNames;
    }

    public static List<String> getColumns(String sql, String datasourceType) {
        DbType jdbcType = DBUtils.translateDbType(datasourceType);
        if (jdbcType == null) {
            return null;
        }
        ArrayList<String> columns = new ArrayList<String>();
        try {
            List statementList = SQLUtils.parseStatements((String)sql, (DbType)jdbcType);
            for (SQLStatement statement : statementList) {
                if (!(statement instanceof SQLSelectStatement)) continue;
                SchemaStatVisitor visitor = new SchemaStatVisitor(jdbcType);
                if (jdbcType.equals((Object)JdbcConstants.ORACLE)) {
                    visitor = new OracleSchemaStatVisitor();
                }
                statement.accept((SQLASTVisitor)visitor);
                SQLSelectStatement selectStatement = (SQLSelectStatement)statement;
                SQLSelectQueryBlock queryBlock = selectStatement.getSelect().getFirstQueryBlock();
                List selectList = queryBlock.getSelectList();
                if (selectList == null || selectList.isEmpty()) continue;
                for (SQLSelectItem selectItem : selectList) {
                    if (StringUtils.isNotBlank((CharSequence)selectItem.getAlias())) {
                        columns.add(selectItem.getAlias());
                        continue;
                    }
                    String outStr = selectItem.toString().trim();
                    if (!outStr.contains(".")) {
                        columns.add(outStr);
                        continue;
                    }
                    String quote = null;
                    if (jdbcType.equals((Object)JdbcConstants.MYSQL) || jdbcType.equals((Object)JdbcConstants.CLICKHOUSE)) {
                        quote = "`";
                    } else if (jdbcType.equals((Object)JdbcConstants.ORACLE) || jdbcType.equals((Object)JdbcConstants.POSTGRESQL)) {
                        quote = "\"";
                    }
                    ArrayList<Integer> indexList = new ArrayList<Integer>();
                    if (quote != null && outStr.contains(quote)) {
                        Stack<Character> stack = new Stack<Character>();
                        for (int i = 0; i < outStr.length(); ++i) {
                            char c = outStr.charAt(i);
                            if (c == '`') {
                                if (!stack.isEmpty()) {
                                    stack.pop();
                                } else {
                                    stack.push(Character.valueOf(c));
                                }
                            }
                            if (c != '.' || !stack.isEmpty()) continue;
                            indexList.add(i);
                        }
                        if (indexList.isEmpty()) {
                            columns.add(outStr);
                            continue;
                        }
                    } else {
                        indexList.add(outStr.lastIndexOf("."));
                    }
                    int index = (Integer)indexList.get(indexList.size() - 1);
                    columns.add(outStr.substring(index + 1));
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6sql\u8bed\u53e5\u4e2d\u7684\u6700\u7ec8\u67e5\u8be2\u7684\u5b57\u6bb5\u540d\u5f02\u5e38");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return columns;
    }

    public static DbType translateDbType(String datasourceType) {
        DbType jdbcType;
        switch (datasourceType.toLowerCase()) {
            case "mysql": {
                jdbcType = JdbcConstants.MYSQL;
                break;
            }
            case "oracle": {
                jdbcType = JdbcConstants.ORACLE;
                break;
            }
            case "postgresql": {
                jdbcType = JdbcConstants.POSTGRESQL;
                break;
            }
            case "clickhouse": {
                jdbcType = JdbcConstants.CLICKHOUSE;
                break;
            }
            default: {
                return null;
            }
        }
        return jdbcType;
    }

    public static boolean onlySelectSql(String sql, String datasourceType) {
        DbType jdbcType;
        switch (datasourceType.toLowerCase()) {
            case "mysql": {
                jdbcType = JdbcConstants.MYSQL;
                break;
            }
            case "oracle": {
                jdbcType = JdbcConstants.ORACLE;
                break;
            }
            case "postgresql": {
                jdbcType = JdbcConstants.POSTGRESQL;
                break;
            }
            case "clickhouse": {
                jdbcType = JdbcConstants.CLICKHOUSE;
                break;
            }
            case "sqlserver": {
                jdbcType = JdbcConstants.SQL_SERVER;
                break;
            }
            default: {
                return true;
            }
        }
        List stmts = SQLUtils.parseStatements((String)sql, (DbType)jdbcType);
        for (SQLStatement stmt : stmts) {
            if (stmt instanceof SQLSelectStatement) continue;
            return false;
        }
        return true;
    }
}

