/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.datasource;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dao.DatasourceDao;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DbDataVO;
import com.gccloud.dataset.vo.FieldInfoVO;
import com.gccloud.dataset.vo.TableInfoVO;
import com.gccloud.dataset.vo.TableInfoVOExtend;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="sqlserver")
public class SqlServerDatasourceServiceImpl
extends ServiceImpl<DatasourceDao, DatasourceEntity>
implements IBaseDatasourceService {
    private static final Logger log = LoggerFactory.getLogger(SqlServerDatasourceServiceImpl.class);

    @Override
    public DataVO executeSql(DatasourceEntity datasource, String sql) {
        DbDataVO dbDataVO = DBUtils.getSqlValue(sql, datasource);
        return new DataVO(dbDataVO.getData(), dbDataVO.getStructure());
    }

    @Override
    public DataVO executeSqlPage(DatasourceEntity datasource, String sql, Integer current, Integer size) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        String countSql = "SELECT COUNT(1) AS COUNT FROM (" + sql + ") AS t";
        log.info("\u6570\u636e\u96c6\u6570\u636e\u8be6\u60c5\u8ba1\u7b97\u603b\u6761\u6570 sql\u8bed\u53e5\uff1a{}", (Object)countSql);
        DbDataVO countData = DBUtils.getSqlValue(countSql, datasource);
        Object count = countData.getData().get(0).get("COUNT");
        int total = Integer.parseInt(count.toString());
        int start = (current - 1) * size;
        List<String> columns = DBUtils.getColumns(sql, datasource.getSourceType());
        String columnStr = columns == null || columns.size() == 0 || columns.contains("*") ? "*" : String.join((CharSequence)",", columns);
        String pageSql = "select " + columnStr + " from (" + sql + ") as t order by 1 offset " + start + " rows fetch next " + 10 + " rows only";
        log.info("\u6570\u636e\u96c6\u6570\u636e\u8be6\u60c5\u5206\u9875 sql\u8bed\u53e5\uff1a{}", (Object)pageSql);
        DbDataVO pageData = DBUtils.getSqlValue(pageSql, datasource);
        PageVO page = new PageVO();
        page.setCurrent((long)current.intValue());
        page.setSize((long)size.intValue());
        page.setTotalCount((long)total);
        page.setTotalPage((long)((total + size - 1) / size));
        page.setList(pageData.getData());
        return new DataVO(page, pageData.getStructure());
    }

    @Override
    public List<TableInfoVO> getTableList(DatasourceEntity datasource) {
        String schema = this.getSchemaFromUrl(datasource.getUrl());
        String sql = "SELECT TABLE_CATALOG as tableCatalog, TABLE_SCHEMA as tableSchema, TABLE_NAME as name\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_TYPE = 'BASE TABLE' AND TABLE_CATALOG = DB_NAME()";
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql = sql + " AND TABLE_SCHEMA = '" + schema + "'";
        }
        DbDataVO dataVO = DBUtils.getSqlValue(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList tableList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(data)) {
            return tableList;
        }
        for (Map<String, Object> map : data) {
            TableInfoVOExtend tableInfoVO = new TableInfoVOExtend();
            String name = String.valueOf(map.get("name"));
            if (map.get("tableSchema") != null) {
                name = map.get("tableSchema") + "." + name;
            }
            tableInfoVO.setName(name);
            tableInfoVO.setStatus(0);
            tableInfoVO.setTableCatalog(String.valueOf(map.get("tableCatalog")));
            tableInfoVO.setTableSchema(String.valueOf(map.get("tableSchema")));
            tableList.add(tableInfoVO);
        }
        return tableList;
    }

    @Override
    public List<TableInfoVO> getViewList(DatasourceEntity datasource) {
        String schema = this.getSchemaFromUrl(datasource.getUrl());
        String sql = "SELECT TABLE_CATALOG as tableCatalog, TABLE_SCHEMA as tableSchema, TABLE_NAME as name\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_TYPE = 'VIEW' AND TABLE_CATALOG = DB_NAME()";
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql = sql + " AND TABLE_SCHEMA = '" + schema + "'";
        }
        DbDataVO dataVO = DBUtils.getSqlValue(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList tableInfoVOS = Lists.newArrayList();
        if (CollectionUtils.isEmpty(data)) {
            return tableInfoVOS;
        }
        for (Map<String, Object> map : data) {
            TableInfoVOExtend tableInfoVO = new TableInfoVOExtend();
            String name = String.valueOf(map.get("name"));
            if (map.get("tableSchema") != null) {
                name = map.get("tableSchema") + "." + name;
            }
            tableInfoVO.setName(name);
            tableInfoVO.setStatus(0);
            tableInfoVO.setTableCatalog(String.valueOf(map.get("tableCatalog")));
            tableInfoVO.setTableSchema(String.valueOf(map.get("tableSchema")));
            tableInfoVOS.add(tableInfoVO);
        }
        return tableInfoVOS;
    }

    @Override
    public List<FieldInfoVO> getTableColumnList(DatasourceEntity datasource, String fullTableName) {
        String schema = "";
        String tableName = "";
        String[] split = fullTableName.split("\\.");
        if (split.length == 1) {
            tableName = split[0];
        } else if (split.length == 2) {
            schema = split[0];
            tableName = split[1];
        } else if (split.length == 3) {
            schema = split[1];
            tableName = split[2];
        }
        String sql = "select COLUMN_NAME,DATA_TYPE from information_schema.columns where table_name = '" + tableName + "'";
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql = sql + " and table_schema = '" + schema + "'";
        }
        DbDataVO dataVO = DBUtils.getSqlValue(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList fieldInfoVOS = Lists.newArrayList();
        if (CollectionUtils.isEmpty(data)) {
            return fieldInfoVOS;
        }
        String columnDescSql = "select a.name  table_name,b.name  column_name, c.value  column_description from sys.tables a inner join sys.columns b on b.object_id = a.object_id left join sys.extended_properties c on c.major_id = b.object_id and c.minor_id = b.column_id where a.name = '" + tableName + "'";
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            columnDescSql = columnDescSql + " and a.schema_id = schema_id('" + schema + "')";
        }
        DbDataVO sqlValue = DBUtils.getSqlValue(columnDescSql, datasource);
        List<Map<String, Object>> columnDescMap = sqlValue.getData();
        ArrayList columnDescList = Lists.newArrayList();
        for (Map<String, Object> columnDesc : columnDescMap) {
            FieldInfoVO fieldInfoVO = new FieldInfoVO();
            fieldInfoVO.setColumnName(String.valueOf(columnDesc.get("column_name")));
            fieldInfoVO.setColumnComment(String.valueOf(columnDesc.get("column_description")));
            columnDescList.add(fieldInfoVO);
        }
        Map<String, String> collect = columnDescList.stream().collect(Collectors.toMap(FieldInfoVO::getColumnName, FieldInfoVO::getColumnComment));
        for (Map<String, Object> map : data) {
            FieldInfoVO fieldInfoVO = new FieldInfoVO();
            fieldInfoVO.setColumnName(String.valueOf(map.get("COLUMN_NAME")));
            fieldInfoVO.setColumnType(String.valueOf(map.get("DATA_TYPE")));
            fieldInfoVO.setColumnComment(collect.get(String.valueOf(map.get("COLUMN_NAME"))));
            fieldInfoVOS.add(fieldInfoVO);
        }
        return fieldInfoVOS;
    }

    @Override
    public DataVO executeProcedure(DatasourceEntity datasource, String procedure, Integer current, Integer size) {
        boolean pageFlag;
        DbDataVO dbDataVO = DBUtils.call(procedure, datasource, current, size);
        boolean bl = pageFlag = current != null && size != null;
        if (pageFlag) {
            return new DataVO(dbDataVO.getPageData(), dbDataVO.getStructure());
        }
        return new DataVO(dbDataVO.getData(), dbDataVO.getStructure());
    }

    private String getSchemaFromUrl(String url) {
        String[] split = url.split(";");
        String schema = "";
        for (String s : split) {
            if (!s.contains("schema=")) continue;
            schema = s.split("=")[1];
        }
        return schema;
    }
}

