/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.datasource;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dao.DatasourceDao;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DbDataVO;
import com.gccloud.dataset.vo.FieldInfoVO;
import com.gccloud.dataset.vo.TableInfoVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mysql")
public class MysqlDatasourceServiceImpl
extends ServiceImpl<DatasourceDao, DatasourceEntity>
implements IBaseDatasourceService {
    private static final Logger log = LoggerFactory.getLogger(MysqlDatasourceServiceImpl.class);

    @Override
    public DataVO executeSql(DatasourceEntity datasource, String sql) {
        DbDataVO dbDataVO = DBUtils.getSqlValue(sql, datasource);
        return new DataVO(dbDataVO.getData(), dbDataVO.getStructure());
    }

    @Override
    public DataVO executeSqlPage(DatasourceEntity datasource, String sql, Integer current, Integer size) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        String countSql = "SELECT COUNT(1) AS COUNT FROM (" + sql + ") AS t";
        log.info("\u6570\u636e\u96c6\u6570\u636e\u8be6\u60c5\u8ba1\u7b97\u603b\u6761\u6570 sql\u8bed\u53e5\uff1a{}", (Object)countSql);
        DbDataVO countData = DBUtils.getSqlValue(countSql, datasource);
        Object count = countData.getData().get(0).get("COUNT");
        int total = Integer.parseInt(count.toString());
        int start = (current - 1) * size;
        List<String> columns = DBUtils.getColumns(sql, datasource.getSourceType());
        String columnStr = columns == null || columns.size() == 0 || columns.contains("*") ? "*" : String.join((CharSequence)",", columns);
        String pageSql = "SELECT " + columnStr + " FROM (" + sql + ") AS t LIMIT " + start + "," + size;
        log.info("\u6570\u636e\u96c6\u6570\u636e\u8be6\u60c5\u5206\u9875 sql\u8bed\u53e5\uff1a{}", (Object)pageSql);
        DbDataVO pageData = DBUtils.getSqlValue(pageSql, datasource);
        PageVO page = new PageVO();
        page.setCurrent((long)current.intValue());
        page.setSize((long)size.intValue());
        page.setTotalCount((long)total);
        page.setTotalPage((long)((total + size - 1) / size));
        page.setList(pageData.getData());
        return new DataVO(page, pageData.getStructure());
    }

    @Override
    public DataVO executeProcedure(DatasourceEntity datasource, String procedure, Integer current, Integer size) {
        boolean pageFlag;
        if (!(procedure = procedure.replaceAll(",\\s*\\?\\s*\\)", ")")).startsWith("{") && !procedure.endsWith("}")) {
            procedure = "{" + procedure + "}";
        }
        DbDataVO dbDataVO = DBUtils.call(procedure, datasource, current, size);
        boolean bl = pageFlag = current != null && size != null;
        if (pageFlag) {
            return new DataVO(dbDataVO.getPageData(), dbDataVO.getStructure());
        }
        return new DataVO(dbDataVO.getData(), dbDataVO.getStructure());
    }

    @Override
    public List<TableInfoVO> getTableList(DatasourceEntity datasource) {
        String sql = "show tables";
        DbDataVO dataVO = DBUtils.getSqlValueWithoutCheck(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList tableList = Lists.newArrayList();
        if (data == null || data.size() == 0) {
            return tableList;
        }
        List<Map<String, Object>> structure = dataVO.getStructure();
        String columnName = structure.get(0).get("fieldName").toString();
        for (Map<String, Object> map : data) {
            TableInfoVO tableInfoVO = new TableInfoVO();
            tableInfoVO.setName(map.get(columnName).toString());
            tableInfoVO.setStatus(0);
            tableList.add(tableInfoVO);
        }
        return tableList;
    }

    @Override
    public List<FieldInfoVO> getTableColumnList(DatasourceEntity datasource, String tableName) {
        String sql = "show full columns from " + tableName;
        DbDataVO dataVO = DBUtils.getSqlValueWithoutCheck(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList fieldList = Lists.newArrayList();
        if (data == null || data.size() == 0) {
            return fieldList;
        }
        boolean flag = data.get(0).containsKey("Field");
        String columnName = flag ? "Field" : "COLUMN_NAME";
        String columnType = flag ? "Type" : "COLUMN_TYPE";
        String columnComment = flag ? "Comment" : "COLUMN_COMMENT";
        for (Map<String, Object> map : data) {
            FieldInfoVO fieldInfoVO = new FieldInfoVO();
            fieldInfoVO.setColumnName(String.valueOf(map.get(columnName)));
            fieldInfoVO.setColumnType(String.valueOf(map.get(columnType)));
            fieldInfoVO.setColumnComment(String.valueOf(map.get(columnComment)));
            fieldList.add(fieldInfoVO);
        }
        return fieldList;
    }

    @Override
    public List<TableInfoVO> getViewList(DatasourceEntity datasource) {
        String sql = "show table status where comment='view'";
        DbDataVO dataVO = DBUtils.getSqlValueWithoutCheck(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList tableList = Lists.newArrayList();
        if (data == null || data.size() == 0) {
            return tableList;
        }
        for (Map<String, Object> map : data) {
            TableInfoVO tableInfoVO = new TableInfoVO();
            tableInfoVO.setName(String.valueOf(map.get("Name")));
            tableInfoVO.setStatus(0);
            tableList.add(tableInfoVO);
        }
        return tableList;
    }

    @Override
    public List<FieldInfoVO> getViewColumnList(DatasourceEntity datasource, String viewName) {
        return this.getTableColumnList(datasource, viewName);
    }
}

