/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.GroovyUtils;
import com.gccloud.common.utils.JSON;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.config.GroovyDataSetConfig;
import com.gccloud.dataset.params.ParamsClient;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.vo.DataVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="script")
public class GroovyDataSetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(GroovyDataSetServiceImpl.class);
    @Resource
    private ParamsClient paramsClient;
    @Resource
    private DatasetPermissionClient datasetPermissionClient;

    @Override
    public String add(DatasetEntity entity) {
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> params) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DatasetParamDTO> finalParams = params;
        DatasetEntity datasetEntity = this.getByIdFromCache(id);
        if (datasetEntity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        if (DatasetConstant.DatasetCache.OPEN.equals(datasetEntity.getCache())) {
            CompletableFuture future = DATASET_CACHE.get((Object)id, key -> this.getData(finalParams, datasetEntity));
            try {
                return future.get();
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u96c6\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.getData(finalParams, datasetEntity);
    }

    private Object getData(List<DatasetParamDTO> finalParams, DatasetEntity datasetEntity) {
        long startTime = System.currentTimeMillis();
        GroovyDataSetConfig config = (GroovyDataSetConfig)datasetEntity.getConfig();
        String script = config.getScript();
        List<DatasetParamDTO> paramList = this.paramsClient.handleParams(finalParams);
        Map<String, Object> paramMap = this.buildParams(paramList, script);
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u811a\u672c\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c", new Object[]{datasetEntity.getName(), datasetEntity.getId(), JSON.toJSONString(finalParams)});
        Object run = GroovyUtils.run((String)script, paramMap);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u811a\u672c\u3011\uff0cID:\u3010{}\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011ms", new Object[]{datasetEntity.getName(), datasetEntity.getId(), endTime - startTime});
        return run;
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        String script = executeDTO.getScript();
        if (StringUtils.isBlank((CharSequence)script)) {
            throw new GlobalException("\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long startTime = System.currentTimeMillis();
        List<DatasetParamDTO> params = executeDTO.getParams();
        params = this.paramsClient.handleParams(params);
        Map<String, Object> paramMap = this.buildParams(params, script);
        DataVO dataVO = new DataVO();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u811a\u672c\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c \u6267\u884c\u811a\u672c\uff1a\u3010{}\u3011", (Object)JSON.toJSONString(params), (Object)script);
        dataVO.setData(GroovyUtils.run((String)script, paramMap));
        long endTime = System.currentTimeMillis();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u811a\u672c\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011ms", (Object)(endTime - startTime));
        return dataVO;
    }

    private Map<String, Object> buildParams(List<DatasetParamDTO> params, String script) {
        Class clazz;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        if (!CollectionUtils.isEmpty(params)) {
            params.forEach(p -> paramMap.put(p.getName(), p.getValue()));
        }
        if ((clazz = GroovyUtils.buildClass((String)script)) == null) {
            throw new GlobalException("\u811a\u672c\u7f16\u8bd1\u5f02\u5e38");
        }
        return paramMap;
    }
}

