/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.utils.GroovyUtils;
import com.gccloud.common.utils.HttpUtils;
import com.gccloud.common.utils.JSON;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.config.HttpDataSetConfig;
import com.gccloud.dataset.params.ParamsClient;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DatasetInfoVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="http")
public class HttpDataSetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(HttpDataSetServiceImpl.class);
    @Resource
    private ParamsClient paramsClient;
    @Resource
    private DatasetPermissionClient datasetPermissionClient;
    public static final String FRONTEND = "frontend";
    public static final String BACKEND = "backend";

    @Override
    public String add(DatasetEntity entity) {
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> paramList) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DatasetEntity entity = this.getByIdFromCache(id);
        if (entity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        ArrayList finalParamList = Lists.newArrayList(paramList);
        if (DatasetConstant.DatasetCache.OPEN.equals(entity.getCache())) {
            CompletableFuture future = DATASET_CACHE.get((Object)id, key -> this.getData(entity, finalParamList));
            try {
                return future.get();
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u96c6\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.getData(entity, finalParamList);
    }

    private Object getData(DatasetEntity entity, List<DatasetParamDTO> finalParamList) {
        HttpDataSetConfig config = (HttpDataSetConfig)entity.getConfig();
        HttpDataSetConfig configCopy = (HttpDataSetConfig)JSON.parseObject((String)JSON.toJSONString((Object)config), HttpDataSetConfig.class);
        List<DatasetParamDTO> params = this.paramsClient.handleParams(finalParamList);
        if ((configCopy = this.handleParams(configCopy, params)).getRequestType().equals(FRONTEND)) {
            log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010HTTP\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u65b9\u5f0f\uff1a\u3010\u524d\u7aef\u4ee3\u7406\u3011\uff0c \u7c7b\u578b\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011", new Object[]{entity.getName(), entity.getId(), configCopy.getMethod(), configCopy.getUrl()});
            if (params != null && !params.isEmpty()) {
                List<DatasetParamDTO> configParams = configCopy.getParamsList();
                block0: for (DatasetParamDTO param : params) {
                    for (DatasetParamDTO configParam : configParams) {
                        if (!param.getName().equals(configParam.getName())) continue;
                        configParam.setValue(param.getValue());
                        continue block0;
                    }
                }
            }
            return configCopy;
        }
        return this.getBackendData(configCopy, entity);
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        String apiInfoJson = executeDTO.getScript();
        if (StringUtils.isBlank((CharSequence)apiInfoJson)) {
            throw new GlobalException("\u6570\u636e\u96c6\u6d4b\u8bd5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        apiInfoJson = this.paramsClient.handleScript(executeDTO.getDataSetType(), apiInfoJson);
        HttpDataSetConfig config = (HttpDataSetConfig)JSON.parseObject((String)apiInfoJson, HttpDataSetConfig.class);
        List<DatasetParamDTO> paramList = executeDTO.getParams();
        paramList = this.paramsClient.handleParams(paramList);
        config = this.handleParams(config, paramList);
        DataVO dataVO = new DataVO();
        if (config.getRequestType().equals(FRONTEND)) {
            dataVO.setData(config);
            return dataVO;
        }
        Object data = this.getBackendData(config, null);
        dataVO.setData(data);
        return dataVO;
    }

    /*
     * WARNING - void declaration
     */
    private HttpDataSetConfig handleParams(HttpDataSetConfig config, List<DatasetParamDTO> datasetParamList) {
        String string;
        String string2;
        String string3;
        String body;
        List<Map<String, Object>> httpParams;
        if (datasetParamList == null || datasetParamList.size() == 0) {
            return config;
        }
        List<Map<String, Object>> headers = config.getHeaders();
        if (headers != null && headers.size() > 0) {
            for (Map<String, Object> header : headers) {
                String string4 = (String)header.get("value");
                if (StringUtils.isBlank((CharSequence)string4) || !string4.contains("${")) continue;
                for (DatasetParamDTO datasetParamDTO : datasetParamList) {
                    if (!string4.contains("${" + datasetParamDTO.getName() + "}")) continue;
                    String replaceValue = this.parameterReplace(datasetParamDTO, (String)header.get("value"));
                    header.put("value", replaceValue);
                }
            }
        }
        if ((httpParams = config.getParams()) != null && httpParams.size() > 0) {
            for (Map map : httpParams) {
                String string5 = (String)map.get("value");
                if (StringUtils.isBlank((CharSequence)string5) || !string5.contains("${")) continue;
                for (DatasetParamDTO paramDTO : datasetParamList) {
                    if (!string5.contains("${" + paramDTO.getName() + "}")) continue;
                    String replaceValue = this.parameterReplace(paramDTO, (String)map.get("value"));
                    map.put("value", replaceValue);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(body = config.getBody()))) {
            for (DatasetParamDTO datasetParamDTO : datasetParamList) {
                if (!body.contains("${" + datasetParamDTO.getName() + "}")) continue;
                body = this.parameterReplace(datasetParamDTO, body);
            }
            config.setBody(body);
        }
        if (StringUtils.isNotBlank((CharSequence)(string3 = config.getUrl()))) {
            void var6_12;
            for (DatasetParamDTO datasetParamDTO : datasetParamList) {
                if (!var6_12.contains(datasetParamDTO.getName())) continue;
                String string6 = this.parameterReplace(datasetParamDTO, (String)var6_12);
            }
            config.setUrl((String)var6_12);
        }
        if (StringUtils.isNotBlank((CharSequence)(string2 = config.getRequestScript()))) {
            void var7_22;
            for (DatasetParamDTO param : datasetParamList) {
                if (!var7_22.contains(param.getName())) continue;
                String string7 = this.parameterReplace(param, (String)var7_22);
            }
            config.setRequestScript((String)var7_22);
        }
        if (StringUtils.isNotBlank((CharSequence)(string = config.getResponseScript()))) {
            void var8_32;
            for (DatasetParamDTO param : datasetParamList) {
                if (!var8_32.contains(param.getName())) continue;
                String string8 = this.parameterReplace(param, (String)var8_32);
            }
            config.setResponseScript((String)var8_32);
        }
        return config;
    }

    private Object getBackendData(HttpDataSetConfig config, DatasetEntity entity) {
        String string;
        String value;
        String key;
        Map<String, String> paramsInUrl;
        long startTime = System.currentTimeMillis();
        HashMap headers = config.getHeaders() == null ? Maps.newHashMap() : config.getHeaders().stream().collect(Collectors.toMap(item -> (String)item.get("key"), item -> (String)item.get("value")));
        HashMap params = config.getParams() == null ? Maps.newHashMap() : config.getParams().stream().collect(Collectors.toMap(item -> (String)item.get("key"), item -> item.get("value")));
        String body = config.getBody();
        HashMap reqParams = Maps.newHashMap();
        reqParams.put("url", Maps.newHashMap());
        reqParams.put("headers", headers);
        reqParams.put("params", params);
        reqParams.put("data", body);
        if (StringUtils.isNotBlank((CharSequence)config.getRequestScript())) {
            HashMap requestScriptMap = Maps.newHashMap();
            requestScriptMap.put("req", reqParams);
            GroovyUtils.run((String)config.getRequestScript(), (Map)requestScriptMap);
        }
        if (!(paramsInUrl = this.getUrlParams(config.getUrl())).isEmpty()) {
            config.setUrl(config.getUrl().replaceAll("\\?.*", ""));
            Map urlParams = (Map)reqParams.get("url");
            urlParams = urlParams == null ? Maps.newHashMap() : urlParams;
            for (Map.Entry<String, String> entry : paramsInUrl.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (!urlParams.containsKey(key)) {
                    params.put(key, value);
                    continue;
                }
                params.put(key, urlParams.get(key));
            }
        }
        StringBuilder url = new StringBuilder(config.getUrl());
        if (params.size() > 0) {
            if (url.indexOf("?") == -1) {
                url.append("?");
            } else {
                url.append("&");
            }
            for (Map.Entry<String, String> entry : params.entrySet()) {
                key = entry.getKey();
                value = String.valueOf(entry.getValue());
                url.append(key).append("=").append(value).append("&");
            }
            url = new StringBuilder(url.substring(0, url.length() - 1));
        }
        if (entity == null) {
            log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010HTTP\u3011\uff09\uff0c \u65b9\u5f0f\uff1a\u3010\u540e\u7aef\u4ee3\u7406\u3011\uff0c \u7c7b\u578b\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c header\uff1a\u3010{}\u3011\uff0c params\uff1a\u3010{}\u3011\uff0c body\uff1a\u3010{}\u3011", new Object[]{config.getMethod(), url, JSON.toJSONString((Object)headers), JSON.toJSONString((Object)params), body});
        } else {
            log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010HTTP\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u65b9\u5f0f\uff1a\u3010\u540e\u7aef\u4ee3\u7406\u3011\uff0c \u7c7b\u578b\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c header\uff1a\u3010{}\u3011\uff0c params\uff1a\u3010{}\u3011\uff0c body\uff1a\u3010{}\u3011", new Object[]{entity.getName(), entity.getId(), config.getMethod(), url, JSON.toJSONString((Object)headers), JSON.toJSONString((Object)params), body});
        }
        Response response = null;
        switch (config.getMethod().toUpperCase()) {
            case "GET": {
                response = HttpUtils.get((String)url.toString(), (Map)headers);
                break;
            }
            case "POST": {
                String contentType;
                HashMap upperCaseHeaders = Maps.newHashMap();
                for (Map.Entry entry : headers.entrySet()) {
                    upperCaseHeaders.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
                }
                Object contentTypeObj = upperCaseHeaders.get("Content-Type".toUpperCase());
                String string2 = contentType = contentTypeObj == null ? "" : contentTypeObj.toString();
                body = contentTypeObj == null && (reqParams.get("data") == null || reqParams.get("data").toString().length() > 0) ? "{}" : (reqParams.get("data") == null ? "" : reqParams.get("data").toString());
                response = HttpUtils.post((String)url.toString(), (String)contentType, (Map)headers, (String)body);
                break;
            }
            default: {
                throw new GlobalException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f");
            }
        }
        if (!response.isSuccessful()) {
            String string3 = response.message();
            String errorMessage = "\u8bf7\u6c42\u5931\u8d25 code: " + response.code();
            if (StringUtils.isNotBlank((CharSequence)string3)) {
                errorMessage = errorMessage + " message: " + string3;
            }
            throw new GlobalException(errorMessage);
        }
        Object var12_16 = null;
        try {
            string = response.body().string();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u83b7\u53d6\u8bf7\u6c42\u54cd\u5e94\u5931\u8d25");
        }
        Object returnResult = string;
        boolean runResponseScript = StringUtils.isNotBlank((CharSequence)config.getResponseScript());
        if (runResponseScript) {
            HashMap responseScriptMap = Maps.newHashMap();
            responseScriptMap.put("responseString", string);
            returnResult = GroovyUtils.run((String)config.getResponseScript(), (Map)responseScriptMap);
        } else {
            if (string.startsWith("{")) {
                returnResult = JSON.parseObject((String)string);
            }
            if (string.startsWith("[")) {
                returnResult = JSON.parseArray((String)string);
            }
        }
        long endTime = System.currentTimeMillis();
        if (entity == null) {
            log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010HTTP\u3011\uff09\u7ed3\u675f\uff0c \u8017\u65f6\uff1a\u3010{}\u3011ms", (Object)(endTime - startTime));
        } else {
            log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010HTTP\u3011\uff0cID:\u3010{}\u3011\uff09\u7ed3\u675f, \u8017\u65f6\uff1a\u3010{}\u3011ms", new Object[]{entity.getName(), entity.getId(), endTime - startTime});
        }
        return returnResult;
    }

    private String parameterReplace(DatasetParamDTO param, String str) {
        str = str.replaceAll("\\$\\{" + param.getName() + "\\}", param.getValue());
        return str;
    }

    private Map<String, String> getUrlParams(String urlString) {
        HashMap map = Maps.newHashMap();
        try {
            String[] params;
            URL url = new URL(urlString);
            String query = url.getQuery();
            for (String param : params = query.split("&")) {
                String[] keyValue = param.split("=");
                String key = URLDecoder.decode(keyValue[0], "UTF-8");
                String value = URLDecoder.decode(keyValue[1], "UTF-8");
                map.put(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    @Override
    public DatasetInfoVO getInfoById(String id) {
        CompletableFuture ifPresent = DATASET_INFO_CACHE.getIfPresent((Object)id);
        if (ifPresent != null) {
            try {
                return (DatasetInfoVO)ifPresent.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DatasetEntity entity = this.getByIdFromCache(id);
        DatasetInfoVO datasetInfoVO = (DatasetInfoVO)BeanConvertUtils.convert((Object)((Object)entity), DatasetInfoVO.class);
        HttpDataSetConfig config = (HttpDataSetConfig)entity.getConfig();
        datasetInfoVO.setFields(config.getFieldList());
        datasetInfoVO.setParams(config.getParamsList());
        datasetInfoVO.setExecutionByFrontend(config.getRequestType().equals(FRONTEND));
        DATASET_INFO_CACHE.put((Object)id, CompletableFuture.completedFuture(datasetInfoVO));
        return datasetInfoVO;
    }

    @Override
    public boolean checkBackendExecutionNeeded(String datasetId) {
        DatasetEntity entity = this.getByIdFromCache(datasetId);
        HttpDataSetConfig config = (HttpDataSetConfig)entity.getConfig();
        return !config.getRequestType().equals(FRONTEND);
    }
}

