/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.utils.JSON;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dataset.dto.DatasetDTO;
import com.gccloud.dataset.dto.DatasetSearchDTO;
import com.gccloud.dataset.dto.ExecuteDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.CategoryEntity;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.entity.LabelEntity;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.ICategoryService;
import com.gccloud.dataset.service.IDatasetLabelService;
import com.gccloud.dataset.service.factory.DataSetServiceFactory;
import com.gccloud.dataset.service.impl.dataset.BaseDatasetServiceImpl;
import com.gccloud.dataset.service.impl.datasource.BaseDatasourceServiceImpl;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.utils.MybatisParameterUtils;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DatasetInfoVO;
import com.gccloud.dataset.vo.DatasetVO;
import com.gccloud.dataset.vo.DeleteCheckVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u96c6"})
@RestController
@RequestMapping(value={"/dataset"})
public class DatasetController {
    @Resource
    private BaseDatasetServiceImpl baseDatasetService;
    @Resource
    private DataSetServiceFactory dataSetServiceFactory;
    @Resource
    private BaseDatasourceServiceImpl datasourceService;
    @Resource
    private IDatasetLabelService datasetLabelService;
    @Resource
    private ICategoryService categoryService;
    @Resource
    private MybatisParameterUtils parameterUtils;

    @ApiOperation(value="\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/page"})
    @ApiPermission(permissions={"dataset:view"})
    public R<PageVO<DatasetVO>> getPage(DatasetSearchDTO searchDTO) {
        List<String> labelIds = searchDTO.getLabelIds();
        List<String> datasetIdList = this.filterDatasetByIdList(labelIds);
        searchDTO.setDatasetIds(datasetIdList);
        if (CollectionUtils.isNotEmpty(labelIds) && CollectionUtils.isEmpty(datasetIdList)) {
            return R.success((Object)new PageVO());
        }
        PageVO<DatasetEntity> page = this.baseDatasetService.getPage(searchDTO);
        PageVO pageVO = (PageVO)BeanConvertUtils.convert(page, PageVO.class);
        List voList = BeanConvertUtils.convert((List)page.getList(), DatasetVO.class);
        for (DatasetVO datasetVO : voList) {
            List<String> labelIdList = this.datasetLabelService.getLabelIdsByDatasetId(datasetVO.getId());
            datasetVO.setLabelIds(labelIdList);
        }
        pageVO.setList(voList);
        return R.success((Object)pageVO);
    }

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/list"})
    @ApiPermission(permissions={"dataset:view"})
    public R<List<DatasetEntity>> getList(DatasetSearchDTO searchDTO) {
        List<String> labelIds = searchDTO.getLabelIds();
        List<String> datasetIdList = this.filterDatasetByIdList(labelIds);
        searchDTO.setDatasetIds(datasetIdList);
        if (CollectionUtils.isNotEmpty(labelIds) && CollectionUtils.isEmpty(datasetIdList)) {
            return R.success((Object)Lists.newArrayList());
        }
        List<DatasetEntity> list = this.baseDatasetService.getList(searchDTO);
        return R.success(list);
    }

    private List<String> filterDatasetByIdList(List<String> labelIds) {
        if (labelIds == null || labelIds.isEmpty()) {
            return null;
        }
        return this.datasetLabelService.getDatasetIdsByLabelIds(labelIds, true);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/add"})
    @ApiPermission(permissions={"dataset:add"})
    public R<String> add(@RequestBody DatasetDTO datasetDTO) {
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.build(datasetDTO.getDatasetType());
        String id = dataSetService.add(datasetDTO);
        List<String> labelIds = datasetDTO.getLabelIds();
        if (labelIds == null || labelIds.isEmpty()) {
            return R.success((Object)id);
        }
        this.datasetLabelService.addByDatasetId(id, labelIds);
        return R.success((Object)id);
    }

    @ApiOperation(value="\u4fee\u6539")
    @PostMapping(value={"/update"})
    @ApiPermission(permissions={"dataset:update"})
    public R<Void> update(@RequestBody DatasetDTO datasetDTO) {
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.build(datasetDTO.getDatasetType());
        dataSetService.update(datasetDTO);
        List<String> labelIds = datasetDTO.getLabelIds();
        this.datasetLabelService.deleteByDatasetId(datasetDTO.getId());
        if (labelIds == null || labelIds.isEmpty()) {
            return R.success();
        }
        this.datasetLabelService.addByDatasetId(datasetDTO.getId(), labelIds);
        return R.success();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete/{id}"})
    @ApiPermission(permissions={"dataset:delete"})
    public R<Void> delete(@PathVariable(value="id") String id) {
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.buildById(id);
        dataSetService.delete(id);
        this.datasetLabelService.deleteByDatasetId(id);
        return R.success();
    }

    @ApiOperation(value="\u5220\u9664\u524d\u68c0\u67e5")
    @PostMapping(value={"/deleteCheck/{id}"})
    @ApiPermission(permissions={"dataset:delete"})
    public R<DeleteCheckVO> deleteCheck(@PathVariable(value="id") String id) {
        DeleteCheckVO deleteCheckVO = this.baseDatasetService.deleteCheck(id);
        return R.success((Object)deleteCheckVO);
    }

    @ApiOperation(value="\u68c0\u67e5\u6570\u636e\u96c6\u5206\u7ec4\u4e0b\u6709\u591a\u5c11\u6570\u636e\u96c6")
    @GetMapping(value={"/getCountByType/{typeId}"})
    @ApiPermission(permissions={"dataset:view"})
    public R<Integer> getCountByType(@PathVariable(value="typeId") String typeId) {
        CategoryEntity category = (CategoryEntity)((Object)this.categoryService.getById((Serializable)((Object)typeId)));
        if (category == null) {
            return R.success((Object)0);
        }
        String ids = category.getIds() + ",";
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.likeRight(CategoryEntity::getIds, (Object)ids);
        List list = this.categoryService.list((Wrapper)queryWrapper);
        List typeIds = list.stream().map(SuperEntity::getId).collect(Collectors.toList());
        typeIds.add(typeId);
        LambdaQueryWrapper datasetQueryWrapper = new LambdaQueryWrapper();
        datasetQueryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        datasetQueryWrapper.in(DatasetEntity::getTypeId, typeIds);
        List sizeList = this.baseDatasetService.list((Wrapper)datasetQueryWrapper);
        return R.success((Object)sizeList.size());
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/info/{id}"})
    @ApiPermission(permissions={"dataset:view"})
    public R<DatasetEntity> info(@PathVariable(value="id") String id) {
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.buildById(id);
        DatasetEntity datasetEntity = (DatasetEntity)((Object)dataSetService.getById((Serializable)((Object)id)));
        return R.success((Object)((Object)datasetEntity));
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u8be6\u60c5")
    @GetMapping(value={"/datasetInfo/{id}"})
    @ApiPermission(permissions={"dataset:view"})
    public R<DatasetInfoVO> getDatasetInfo(@PathVariable(value="id") String id) {
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.buildById(id);
        DatasetInfoVO infoVO = dataSetService.getInfoById(id);
        List<LabelEntity> labels = this.datasetLabelService.getLabelByDatasetId(id);
        infoVO.setLabelList(labels);
        return R.success((Object)infoVO);
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u540d\u79f0\u91cd\u590d\u5224\u65ad")
    @PostMapping(value={"/checkRepeat"})
    @ApiPermission(permissions={"dataset:view"})
    public R<Boolean> checkRepeat(@RequestBody DatasetEntity datasetEntity) {
        boolean nameRepeat = this.baseDatasetService.checkNameRepeat(datasetEntity.getId(), datasetEntity.getName(), datasetEntity.getModuleCode());
        return R.success((Object)nameRepeat);
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u6267\u884c\u6d4b\u8bd5")
    @PostMapping(value={"/execute/test"})
    @ApiPermission(permissions={"dataset:execute"})
    public R<Object> execute(@RequestBody TestExecuteDTO executeDTO) {
        if (StringUtils.isBlank((CharSequence)executeDTO.getDataSetType())) {
            return R.error((String)"\u6570\u636e\u96c6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.build(executeDTO.getDataSetType());
        DataVO execute = dataSetService.execute(executeDTO);
        HashMap result = Maps.newHashMap();
        result.put("data", execute.getData());
        result.put("structure", execute.getStructure());
        if (StringUtils.isNotBlank((CharSequence)executeDTO.getDataSourceId())) {
            DatasourceEntity datasource = this.datasourceService.getInfoById(executeDTO.getDataSourceId());
            if (executeDTO.getDataSetType().equals("original")) {
                String originalString = executeDTO.getScript();
                JSONObject originalTest = JSON.parseObject((String)originalString);
                String tableName = originalTest.getString("tableName");
                executeDTO.setScript("select 1 from " + tableName);
            }
            String sql = "mybatis".equals(executeDTO.getSyntaxType()) ? this.parameterUtils.updateParamsConfig(executeDTO.getScript(), executeDTO.getParams()) : DBUtils.updateParamsConfig(executeDTO.getScript(), executeDTO.getParams());
            List<String> tableNameList = DBUtils.getTableNames(sql, datasource.getSourceType());
            result.put("tableNameList", tableNameList);
        }
        return R.success((Object)result);
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u6267\u884c")
    @PostMapping(value={"/execute"})
    @ApiPermission(permissions={"dataset:execute"})
    public R<Object> execute(@RequestBody ExecuteDTO executeDTO) {
        if (StringUtils.isBlank((CharSequence)executeDTO.getDataSetType()) && StringUtils.isBlank((CharSequence)executeDTO.getDataSetId())) {
            return R.error((String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IBaseDataSetService dataSetService = StringUtils.isBlank((CharSequence)executeDTO.getDataSetType()) ? this.dataSetServiceFactory.buildById(executeDTO.getDataSetId()) : this.dataSetServiceFactory.build(executeDTO.getDataSetType());
        boolean executionNeeded = dataSetService.checkBackendExecutionNeeded(executeDTO.getDataSetId());
        PageVO<Object> data = executeDTO.getCurrent() != null && executeDTO.getSize() != null ? dataSetService.execute(executeDTO.getDataSetId(), executeDTO.getParams(), executeDTO.getCurrent(), executeDTO.getSize()) : dataSetService.execute(executeDTO.getDataSetId(), executeDTO.getParams());
        HashMap result = Maps.newHashMap();
        result.put("data", data);
        result.put("executionByFrontend", !executionNeeded);
        return R.success((Object)result);
    }
}

