/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.utils;

import com.gccloud.common.exception.GlobalException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.transform.TimedInterrupt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyUtils {
    private static final Logger log = LoggerFactory.getLogger(GroovyUtils.class);
    static final Cache<String, Class> CACHE_CLASS = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public static Object run(String groovyScript, Map<String, Object> params) {
        Class clazz = GroovyUtils.buildClass(groovyScript);
        if (clazz == null) {
            return null;
        }
        Binding binding = new Binding();
        Map variables = binding.getVariables();
        if (params != null) {
            variables.putAll(params);
        }
        try {
            Script script = InvokerHelper.createScript((Class)clazz, (Binding)binding);
            Object result = script.run();
            return result;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u811a\u672c\u6267\u884c\u5931\u8d25", e);
        }
    }

    public static Class buildClass(String groovyScript) {
        if (StringUtils.isBlank((CharSequence)groovyScript)) {
            return null;
        }
        Class clazz = (Class)CACHE_CLASS.get((Object)groovyScript, script -> {
            try {
                return GroovyUtils.buildClassSafe(script);
            }
            catch (Exception e) {
                log.error("\u811a\u672c {} \u7f16\u8bd1\u5931\u8d25:{}", script, (Object)e);
                return null;
            }
        });
        return clazz;
    }

    public static Class<?> buildClassSafe(String groovyScript) {
        CompilerConfiguration config = new CompilerConfiguration();
        SecureASTCustomizer secure = new SecureASTCustomizer();
        secure.setClosuresAllowed(true);
        ArrayList<Integer> tokensBlacklist = new ArrayList<Integer>();
        tokensBlacklist.add(571);
        tokensBlacklist.add(701);
        secure.setTokensBlacklist(tokensBlacklist);
        config.addCompilationCustomizers(new CompilationCustomizer[]{secure});
        ArrayList<Class<WhileStatement>> statementBlacklist = new ArrayList<Class<WhileStatement>>();
        statementBlacklist.add(WhileStatement.class);
        secure.setStatementsBlacklist(statementBlacklist);
        HashMap<String, Integer> timeoutArgs = new HashMap<String, Integer>();
        timeoutArgs.put("value", 3);
        config.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(timeoutArgs, TimedInterrupt.class)});
        config.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        new NoSystemExitSandbox().register();
        new NoRunTimeSandbox().register();
        new NoFileSandbox().register();
        ClassLoader parent = GroovyUtils.class.getClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent, config);
        Class groovyClass = loader.parseClass(groovyScript);
        try {
            loader.close();
        }
        catch (IOException var5) {
            var5.printStackTrace();
        }
        return groovyClass;
    }

    static class NoProcessSandbox
    extends GroovyInterceptor {
        NoProcessSandbox() {
        }

        public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
            if (receiver == Process.class) {
                throw new SecurityException("No call on Process please");
            }
            return super.onStaticCall(invoker, receiver, method, args);
        }
    }

    static class NoFileSandbox
    extends GroovyInterceptor {
        NoFileSandbox() {
        }

        public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
            if (receiver == File.class) {
                throw new SecurityException("No call on File please");
            }
            return super.onStaticCall(invoker, receiver, method, args);
        }
    }

    static class NoRunTimeSandbox
    extends GroovyInterceptor {
        NoRunTimeSandbox() {
        }

        public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
            if (receiver == Runtime.class) {
                throw new SecurityException("No call on RunTime please");
            }
            return super.onStaticCall(invoker, receiver, method, args);
        }
    }

    static class NoSystemExitSandbox
    extends GroovyInterceptor {
        NoSystemExitSandbox() {
        }

        public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
            if (receiver == System.class && method.equals("exit")) {
                throw new SecurityException("No call on System.exit() please");
            }
            return super.onStaticCall(invoker, receiver, method, args);
        }
    }
}

