/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.utils;

import com.gccloud.common.utils.cover.ICoverLife;
import com.gccloud.common.vo.PageVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanConvertUtils.class);

    public static <T> PageVO<T> convertPage(PageVO<? extends Object> pageEntity, Class<T> targetClass) {
        return BeanConvertUtils.convertPage(pageEntity, targetClass, null);
    }

    public static <T> PageVO<T> convertPage(PageVO<? extends Object> pageEntity, Class<T> targetClass, ICoverLife<?, T> coverLife) {
        PageVO<T> pageVO = new PageVO<T>();
        pageVO.setTotalPage(pageEntity.getTotalPage());
        pageVO.setTotalCount(pageEntity.getTotalCount());
        pageVO.setCurrent(pageEntity.getCurrent());
        pageVO.setSize(pageEntity.getSize());
        List<T> list = BeanConvertUtils.convert(pageEntity.getList(), targetClass, coverLife);
        pageVO.setList(list);
        return pageVO;
    }

    public static <T> List<T> convert(List<? extends Object> sourceList, Class<T> targetClass) {
        return BeanConvertUtils.convert(sourceList, targetClass, null);
    }

    public static <T> List<T> convert(List<? extends Object> sourceList, Class<T> targetClass, ICoverLife<?, T> coverLife) {
        if (sourceList == null || sourceList.size() == 0) {
            return Lists.newArrayList();
        }
        ArrayList targetList = Lists.newArrayListWithCapacity((int)sourceList.size());
        for (Object object : sourceList) {
            Object target = null;
            try {
                target = targetClass.newInstance();
                BeanUtils.copyProperties((Object)object, target);
                if (coverLife != null) {
                    coverLife.after(object, target);
                }
                targetList.add(target);
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return targetList;
    }

    public static <T> T convert(Object source, Class<T> targetClass) {
        try {
            if (source == null) {
                return targetClass.newInstance();
            }
            T target = targetClass.newInstance();
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static void convert(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }
}

