/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.utils;

import com.gccloud.dataroom.core.config.bean.DataRoomMinioConfig;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.io.InputStream;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="minio")
public class MinioFileInterface {
    @Resource
    private DataRoomMinioConfig minioConfig;

    private MinioClient init() throws Exception {
        MinioClient build = MinioClient.builder().endpoint(this.minioConfig.getUrl()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
        boolean found = build.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.minioConfig.getBucketName())).build());
        if (!found) {
            build.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.minioConfig.getBucketName())).build());
        }
        return build;
    }

    public void deleteObject(String objectName) throws Exception {
        MinioClient minioClient = this.init();
        minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectName)).build());
    }

    public InputStream download(String objectName) throws Exception {
        MinioClient minioClient = this.init();
        return minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectName)).build());
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires) throws Exception {
        String url = "";
        if (expires == null) {
            expires = 604800;
        }
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).build();
        MinioClient minioClient = this.init();
        url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        return url;
    }
}

