/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.manage.controller;

import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.validator.ValidatorUtils;
import com.gccloud.common.validator.group.Insert;
import com.gccloud.common.validator.group.Update;
import com.gccloud.common.vo.MixinsResp;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.module.basic.entity.PageEntity;
import com.gccloud.dataroom.core.module.basic.entity.PagePreviewEntity;
import com.gccloud.dataroom.core.module.manage.dto.DataRoomPageDTO;
import com.gccloud.dataroom.core.module.manage.dto.DataRoomSearchDTO;
import com.gccloud.dataroom.core.module.manage.service.IDataRoomPagePreviewService;
import com.gccloud.dataroom.core.module.manage.service.IDataRoomPageService;
import com.gccloud.dataroom.core.module.manage.vo.StaticFileVO;
import com.gccloud.dataroom.core.utils.Webjars;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bigScreen/design"})
@Api(tags={"\u5927\u5c4f\u9875\u4ee5\u53ca\u5927\u5c4f\u7ec4\u4ef6\u8bbe\u8ba1"})
public class DataRoomPageController {
    private static final Logger log = LoggerFactory.getLogger(DataRoomPageController.class);
    @Resource
    private IDataRoomPageService bigScreenPageService;
    @Resource
    private DataRoomConfig bigScreenConfig;
    @Resource
    private IDataRoomPagePreviewService previewService;

    @ApiPermission(permissions={"screen:view"})
    @GetMapping(value={"/info/code/{code}"})
    @ApiOperation(value="\u5927\u5c4f\u9875/\u7ec4\u4ef6\u8be6\u60c5", position=10, produces="application/json")
    public MixinsResp<DataRoomPageDTO> info(@PathVariable(value="code") String code) {
        if (code.startsWith("preview")) {
            PagePreviewEntity preview = this.previewService.getByCode(code);
            MixinsResp r = new MixinsResp().setData((Object)((DataRoomPageDTO)preview.getConfig()));
            r.setCode(Integer.valueOf(200));
            return r;
        }
        PageEntity bigScreen = this.bigScreenPageService.getByCode(code);
        DataRoomPageDTO bigScreenPageDTO = (DataRoomPageDTO)bigScreen.getConfig();
        BeanConvertUtils.convert((Object)bigScreen, (Object)bigScreenPageDTO);
        MixinsResp resp = new MixinsResp().setData((Object)bigScreenPageDTO);
        resp.setCode(Integer.valueOf(200));
        return resp;
    }

    @ApiPermission(permissions={"screen:view"})
    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5927\u5c4f/\u7ec4\u4ef6\u5206\u9875\u5217\u8868", position=10, produces="application/json")
    public MixinsResp<PageVO<PageEntity>> page(DataRoomSearchDTO searchDTO) {
        PageVO<PageEntity> page = this.bigScreenPageService.getByCategory(searchDTO);
        MixinsResp resp = new MixinsResp().setData(page);
        resp.setCode(Integer.valueOf(200));
        return resp;
    }

    @ApiPermission(permissions={"screen:add"})
    @PostMapping(value={"/add"})
    @ApiOperation(value="\u4ece\u7a7a\u767d\u65b0\u589e\u5927\u5c4f/\u7ec4\u4ef6", position=20, produces="application/json")
    public R<String> add(@RequestBody DataRoomPageDTO bigScreenPageDTO) {
        ValidatorUtils.validateEntity((Object)bigScreenPageDTO, (Class[])new Class[]{Insert.class});
        this.bigScreenPageService.add(bigScreenPageDTO);
        return R.success((Object)bigScreenPageDTO.getCode());
    }

    @ApiPermission(permissions={"screen:update"})
    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5927\u5c4f/\u7ec4\u4ef6", position=30, produces="application/json")
    public R<String> update(@RequestBody DataRoomPageDTO bigScreenPageDTO) {
        if (Boolean.TRUE.equals(bigScreenPageDTO.getIsPreview())) {
            String code = this.previewService.add(bigScreenPageDTO);
            return R.success((Object)code);
        }
        ValidatorUtils.validateEntity((Object)bigScreenPageDTO, (Class[])new Class[]{Update.class});
        this.bigScreenPageService.update(bigScreenPageDTO);
        return R.success((Object)bigScreenPageDTO.getCode());
    }

    @ApiPermission(permissions={"screen:delete"})
    @PostMapping(value={"/delete/{code}"})
    @ApiOperation(value="\u5220\u9664\u5927\u5c4f/\u7ec4\u4ef6", position=40, produces="application/json")
    public R<Void> delete(@PathVariable String code) {
        PageEntity bigScreenPage = this.bigScreenPageService.getByCode(code);
        if (bigScreenPage == null) {
            return R.success();
        }
        this.bigScreenPageService.deleteByCode(code);
        return R.success();
    }

    @ApiPermission(permissions={"screen:add"})
    @PostMapping(value={"/copy/{code}"})
    @ApiOperation(value="\u590d\u5236\u5927\u5c4f/\u7ec4\u4ef6", position=50, produces="application/json")
    public R<String> copy(@PathVariable String code) {
        PageEntity bigScreenPage = this.bigScreenPageService.getByCode(code);
        if (bigScreenPage == null) {
            throw new GlobalException("\u5927\u5c4f\u9875\u4e0d\u5b58\u5728");
        }
        String newCode = this.bigScreenPageService.copy(bigScreenPage);
        return R.success((Object)newCode);
    }

    @ApiPermission(permissions={"screen:add"})
    @PostMapping(value={"/add/template"})
    @ApiOperation(value="\u4ece\u6a21\u677f\u65b0\u589e\u5927\u5c4f\u9875", position=20, produces="application/json")
    public R<String> addByTemplate(@RequestBody DataRoomPageDTO bigScreenPageDTO) {
        String code = this.bigScreenPageService.addByTemplate(bigScreenPageDTO);
        return R.success((Object)code);
    }

    @PostMapping(value={"/get/template"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u83b7\u53d6\u914d\u7f6e", position=20, produces="application/json")
    public MixinsResp<DataRoomPageDTO> getByTemplate(@RequestBody DataRoomPageDTO bigScreenPageDTO) {
        DataRoomPageDTO config = this.bigScreenPageService.getConfigByTemplate(bigScreenPageDTO);
        MixinsResp resp = new MixinsResp().setData((Object)config);
        resp.setCode(Integer.valueOf(200));
        return resp;
    }

    @ApiPermission
    @GetMapping(value={"/bg/list"})
    @ApiOperation(value="\u80cc\u666f\u56fe\u7247\u5217\u8868", position=60, produces="application/json")
    public R<List<StaticFileVO>> getBgList() {
        List<String> staticFileList = Webjars.BIG_SCREEN_BG;
        ArrayList bgList = Lists.newArrayList();
        String urlPrefix = this.bigScreenConfig.getFile().getUrlPrefix() + "bigScreenBg/";
        for (String fileName : staticFileList) {
            StaticFileVO fileVO = new StaticFileVO();
            fileVO.setUrl(urlPrefix + fileName);
            fileVO.setName(fileName);
            bgList.add(fileVO);
        }
        return R.success((Object)bgList);
    }

    @ApiPermission
    @GetMapping(value={"/map/list/{level}"})
    @ApiOperation(value="\u5730\u56fe\u6570\u636e\u5217\u8868", position=60, produces="application/json")
    public R<List<StaticFileVO>> getMapJsonList(@PathVariable(value="level") String level) {
        List<Object> staticFileList = Lists.newArrayList();
        if ("country".equals(level)) {
            staticFileList = Webjars.COUNTRY_MAP_DATA;
        }
        if ("province".equals(level)) {
            staticFileList = Webjars.PROVINCE_MAP_DATA;
        }
        ArrayList bgList = Lists.newArrayList();
        String urlPrefix = "static/chinaMap/" + level + "/";
        for (String string : staticFileList) {
            StaticFileVO fileVO = new StaticFileVO();
            fileVO.setUrl(string);
            fileVO.setName(string.replace(".json", ""));
            bgList.add(fileVO);
        }
        return R.success((Object)bgList);
    }

    @ApiPermission
    @PostMapping(value={"/name/repeat"})
    @ApiOperation(value="\u5927\u5c4f/\u7ec4\u4ef6\u540d\u79f0\u662f\u5426\u91cd\u590d", position=60, produces="application/json")
    public R<Boolean> nameRepeat(@RequestBody PageEntity pageEntity) {
        boolean repeat = this.bigScreenPageService.checkNameRepeat(pageEntity);
        return R.success((Object)repeat);
    }
}

