/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.pool.sftp;

import com.gccloud.dataroom.core.config.bean.DataRoomSftpConfig;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="sftp")
public class SftpClientFactory
extends BasePooledObjectFactory<ChannelSftp> {
    private static final Logger log = LoggerFactory.getLogger(SftpClientFactory.class);
    @Resource
    private DataRoomSftpConfig config;

    public ChannelSftp create() {
        ChannelSftp channel = null;
        try {
            if (StringUtils.isBlank((CharSequence)this.config.getUsername()) || StringUtils.isBlank((CharSequence)this.config.getPassword())) {
                log.error("SFTP\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return null;
            }
            JSch jsch = new JSch();
            if (StringUtils.isNotBlank((CharSequence)this.config.getPrivateKey())) {
                jsch.addIdentity(this.config.getPrivateKey());
            }
            Session sshSession = jsch.getSession(this.config.getUsername(), this.config.getHost(), this.config.getPort().intValue());
            sshSession.setPassword(this.config.getPassword());
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            channel = (ChannelSftp)sshSession.openChannel("sftp");
            channel.connect();
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5 sftp \u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return channel;
    }

    public PooledObject<ChannelSftp> wrap(ChannelSftp channelSftp) {
        return new DefaultPooledObject((Object)channelSftp);
    }

    public void destroyObject(PooledObject<ChannelSftp> p) {
        ChannelSftp channelSftp = (ChannelSftp)p.getObject();
        channelSftp.disconnect();
    }

    public boolean validateObject(PooledObject<ChannelSftp> p) {
        ChannelSftp channelSftp = (ChannelSftp)p.getObject();
        try {
            if (channelSftp.isClosed()) {
                return false;
            }
            channelSftp.cd("/");
        }
        catch (Exception e) {
            log.error("ChannelSftp \u4e0d\u53ef\u7528");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
        return true;
    }
}

