/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.biz.component.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.module.biz.component.dao.DataRoomBizComponentDao;
import com.gccloud.dataroom.core.module.biz.component.dto.BizComponentSearchDTO;
import com.gccloud.dataroom.core.module.biz.component.entity.BizComponentEntity;
import com.gccloud.dataroom.core.module.biz.component.service.IBizComponentService;
import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import com.gccloud.dataroom.core.module.file.service.IDataRoomOssService;
import com.gccloud.dataroom.core.utils.CodeGenerateUtils;
import com.gccloud.dataroom.core.utils.PathUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.Base64;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="dataRoomBizComponentService")
public class BizComponentServiceImpl
extends ServiceImpl<DataRoomBizComponentDao, BizComponentEntity>
implements IBizComponentService {
    private static final Logger log = LoggerFactory.getLogger(BizComponentServiceImpl.class);
    @Resource
    private DataRoomConfig bigScreenConfig;
    @Resource
    private IDataRoomOssService ossService;
    public static final String COPY_SUFFIX = "-\u526f\u672c";

    @Override
    public PageVO<BizComponentEntity> getPage(BizComponentSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getName()), BizComponentEntity::getName, (Object)searchDTO.getName());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getType()), BizComponentEntity::getType, (Object)searchDTO.getType());
        queryWrapper.orderByAsc(BizComponentEntity::getOrderNum);
        queryWrapper.orderByDesc(SuperEntity::getCreateDate);
        PageVO page = this.page(searchDTO, queryWrapper);
        List list = page.getList();
        String urlPrefix = this.bigScreenConfig.getFile().getUrlPrefix();
        if (!urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix + "/";
        }
        for (BizComponentEntity entity : list) {
            if (StringUtils.isBlank((CharSequence)entity.getCoverPicture())) continue;
            entity.setCoverPicture(urlPrefix + entity.getCoverPicture().replace("\\", "/"));
        }
        return page;
    }

    @Override
    public List<BizComponentEntity> getList(BizComponentSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getName()), BizComponentEntity::getName, (Object)searchDTO.getName());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getType()), BizComponentEntity::getType, (Object)searchDTO.getType());
        List list = this.list((Wrapper)queryWrapper);
        String urlPrefix = this.bigScreenConfig.getFile().getUrlPrefix();
        if (!urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix + "/";
        }
        for (BizComponentEntity entity : list) {
            if (StringUtils.isBlank((CharSequence)entity.getCoverPicture())) continue;
            entity.setCoverPicture(urlPrefix + entity.getCoverPicture().replace("\\", "/"));
        }
        return list;
    }

    @Override
    public BizComponentEntity getInfoByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new GlobalException("\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizComponentEntity::getCode, (Object)code);
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() == 0) {
            throw new GlobalException("\u7ec4\u4ef6\u4e0d\u5b58\u5728");
        }
        BizComponentEntity bizComponentEntity = (BizComponentEntity)list.get(0);
        String urlPrefix = this.bigScreenConfig.getFile().getUrlPrefix();
        if (!urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix + "/";
        }
        for (BizComponentEntity entity : list) {
            String coverPicture = entity.getCoverPicture();
            if (StringUtils.isBlank((CharSequence)coverPicture)) continue;
            if (coverPicture.startsWith("/")) {
                coverPicture = coverPicture.substring(1);
            }
            entity.setCoverPicture(urlPrefix + PathUtils.normalizePath(coverPicture));
        }
        return bizComponentEntity;
    }

    @Override
    public String add(BizComponentEntity entity) {
        boolean repeat = this.checkName(null, entity.getName());
        if (repeat) {
            throw new GlobalException("\u7ec4\u4ef6\u540d\u79f0\u91cd\u590d");
        }
        String code = CodeGenerateUtils.generate("bizComponent");
        entity.setCode(code);
        if (StringUtils.isNotBlank((CharSequence)entity.getCoverPicture())) {
            String base64Str = entity.getCoverPicture();
            String fileUrl = this.saveCoverPicture(base64Str, entity.getCode());
            entity.setCoverPicture(fileUrl);
        }
        this.save(entity);
        return code;
    }

    @Override
    public void update(BizComponentEntity entity) {
        boolean repeat = this.checkName(entity.getId(), entity.getName());
        if (repeat) {
            throw new GlobalException("\u7ec4\u4ef6\u540d\u79f0\u91cd\u590d");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getCoverPicture())) {
            String base64Str = entity.getCoverPicture();
            String fileUrl = this.saveCoverPicture(base64Str, entity.getCode());
            entity.setCoverPicture(fileUrl);
        }
        this.updateById(entity);
    }

    private String saveCoverPicture(String base64String, String fileName) {
        String fileUrl = "";
        if (StringUtils.isBlank((CharSequence)base64String)) {
            return fileUrl;
        }
        try {
            base64String = base64String.substring(base64String.indexOf(",") + 1);
            byte[] imageBytes = Base64.getDecoder().decode(base64String);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
            DataRoomFileEntity fileEntity = new DataRoomFileEntity();
            String filePath = "cover" + File.separator + fileName + ".png";
            this.ossService.upload(inputStream, filePath, 0L, fileEntity);
            log.info("\u7ec4\u4e1a\u52a1\u4ef6\u5c01\u9762\u4fdd\u5b58\u81f3\uff1a{}", (Object)filePath);
            fileUrl = fileEntity.getUrl();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return fileUrl;
    }

    @Override
    public String copy(String code) {
        BizComponentEntity copyFrom = this.getInfoByCode(code);
        if (copyFrom == null) {
            throw new GlobalException("\u6e90\u4e1a\u52a1\u7ec4\u4ef6\u4e0d\u5b58\u5728");
        }
        String oldCode = copyFrom.getCode();
        copyFrom.setId(null);
        String oldName = copyFrom.getName();
        if (oldName.contains(COPY_SUFFIX) && StringUtils.isBlank((CharSequence)(oldName = oldName.substring(0, oldName.indexOf(COPY_SUFFIX))))) {
            oldName = "\u7ec4\u4ef6";
        }
        copyFrom.setName(oldName + COPY_SUFFIX);
        int i = 1;
        while (this.checkName(null, copyFrom.getName())) {
            copyFrom.setName(oldName + COPY_SUFFIX + i);
            ++i;
        }
        copyFrom.setCode(CodeGenerateUtils.generate("bizComponent"));
        String copyUrl = this.copyCoverPicture(oldCode, copyFrom.getCode());
        if (StringUtils.isBlank((CharSequence)copyUrl)) {
            copyFrom.setCoverPicture(null);
        } else {
            copyFrom.setCoverPicture(copyUrl);
        }
        this.save(copyFrom);
        return copyFrom.getCode();
    }

    private String copyCoverPicture(String oldFileName, String newFileName) {
        if (StringUtils.isBlank((CharSequence)oldFileName)) {
            return "";
        }
        String oldFile = "cover" + File.separator + oldFileName + ".png";
        String newFilePath = "cover" + File.separator + newFileName + ".png";
        return this.ossService.copy(oldFile, newFilePath);
    }

    @Override
    public void delete(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u7ec4\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public boolean checkName(String id, String name) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(BizComponentEntity::getName, (Object)name);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            queryWrapper.ne(SuperEntity::getId, (Object)id);
        }
        return this.list((Wrapper)queryWrapper).size() > 0;
    }
}

