/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.exception;

import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.vo.R;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@ConditionalOnProperty(prefix="gc.starter.dataroom.component", name={"DataRoomGlobalExceptionHandler"}, havingValue="DataRoomGlobalExceptionHandler", matchIfMissing=true)
public class DataRoomGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DataRoomGlobalExceptionHandler.class);

    @PostConstruct
    public void init() {
        log.info("----------------------------------------");
        log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u5168\u5c40\u5f02\u5e38\u5904\u7406\uff0c\u5982\u679c\u548c\u9879\u76ee\u4e2d\u7684\u5168\u5c40\u5f02\u5e38\u5904\u7406\u51b2\u7a81\uff0c\u53ef\u4ee5\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6egc.starter.dataroom.component.DataRoomGlobalExceptionHandler=false\u7981\u7528\u8be5\u5168\u5c40\u5f02\u5e38\u5904\u7406");
        log.info("----------------------------------------");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public R<String> httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        R r = new R();
        r.setCode(Integer.valueOf(500));
        r.setMsg("\u4e0d\u652f\u6301\u8be5\u8bf7\u6c42\u65b9\u5f0f");
        return r;
    }

    @ExceptionHandler(value={GlobalException.class})
    public R<String> exception(HttpServletRequest request, GlobalException e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        R r = new R();
        r.setCode(Integer.valueOf(e.getCode()));
        r.setMsg(e.getMessage());
        return r;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public R<String> illegalArgumentException(Exception e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        return R.error((String)"\u53c2\u6570\u975e\u6cd5");
    }

    @ExceptionHandler(value={Exception.class})
    public R<String> handleException(Exception e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        return R.error((String)"\u670d\u52a1\u5668\u5f02\u5e38");
    }
}

