/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.file.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.dashboard.core.config.DashboardConfig;
import com.gccloud.dashboard.core.config.bean.FileConfig;
import com.gccloud.dashboard.core.module.file.entity.DashboardFileEntity;
import com.gccloud.dashboard.core.module.file.service.IDashboardFileService;
import com.gccloud.dashboard.core.module.file.service.IDashboardOssService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(prefix="gc.starter.dashboard.component", name={"IDashboardOssService"}, havingValue="SysLocalFileServiceImpl", matchIfMissing=true)
public class DashboardLocalFileServiceImpl
implements IDashboardOssService {
    private static final Logger log = LoggerFactory.getLogger(DashboardLocalFileServiceImpl.class);
    @Resource
    private DashboardConfig dashboardConfig;
    @Resource
    private IDashboardFileService sysFileService;

    @Override
    public DashboardFileEntity upload(MultipartFile file, DashboardFileEntity fileEntity, HttpServletResponse response, HttpServletRequest request) {
        String originalFilename = file.getOriginalFilename();
        String extension = FilenameUtils.getExtension((String)originalFilename);
        FileConfig fileConfig = this.dashboardConfig.getFile();
        if (!fileConfig.getAllowedFileExtensionName().contains("*") && !fileConfig.getAllowedFileExtensionName().contains(extension)) {
            log.error("\u4e0d\u652f\u6301 {} \u6587\u4ef6\u7c7b\u578b", (Object)extension);
            throw new GlobalException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
        }
        String id = IdWorker.getIdStr();
        String newFileName = id + "." + extension;
        String basePath = this.dashboardConfig.getFile().getBasePath();
        String destPath = basePath + File.separator + newFileName;
        long size = file.getSize();
        try {
            File dest = new File(destPath);
            file.transferTo(dest);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            log.error(String.format("\u6587\u4ef6 %s \u5b58\u50a8\u5230 %s \u5931\u8d25", originalFilename, destPath));
            throw new GlobalException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        fileEntity.setOriginalName(originalFilename);
        fileEntity.setNewName(newFileName);
        fileEntity.setPath(basePath);
        fileEntity.setSize(size);
        fileEntity.setExtension(extension);
        fileEntity.setUrl("/" + newFileName);
        return fileEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String fileId, HttpServletResponse response, HttpServletRequest request) {
        DashboardFileEntity fileEntity = (DashboardFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            log.error("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        response.setContentType("application/x-msdownload");
        response.setContentType("multipart/form-data");
        response.setHeader("Access-Control-Expose-Headers", "filename");
        try {
            response.setHeader("filename", URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        String filePath = fileEntity.getPath() + File.separator + fileEntity.getNewName();
        File file = new File(filePath);
        if (!file.exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            log.error("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            ((InputStream)is).close();
            response.getOutputStream().close();
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            log.error(String.format("\u4e0b\u8f7d\u6587\u4ef6%s\u5931\u8d25", fileEntity.getOriginalName()));
        }
        finally {
            this.sysFileService.updateDownloadCount(1, fileId);
        }
    }

    @Override
    public void delete(String fileId) {
        DashboardFileEntity fileEntity = (DashboardFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        this.sysFileService.removeById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            log.error("\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        String filePath = fileEntity.getPath() + File.separator + fileEntity.getNewName();
        File file = new File(filePath);
        if (!file.exists()) {
            log.error("\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        file.delete();
    }
}

