/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.file.controller;

import com.gccloud.common.controller.SuperController;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dashboard.core.module.file.dto.FileSearchDTO;
import com.gccloud.dashboard.core.module.file.entity.DashboardFileEntity;
import com.gccloud.dashboard.core.module.file.service.IDashboardFileService;
import com.gccloud.dashboard.core.module.file.service.IDashboardOssService;
import com.gccloud.dashboard.core.module.file.vo.SysFileVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiSort;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dashboard/file"})
@Api(tags={"\u6587\u4ef6\u7ba1\u7406"})
@ApiSort(value=100)
public class DashboardFileController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(DashboardFileController.class);
    @Resource
    private IDashboardOssService sysOssService;
    @Resource
    private IDashboardFileService fileService;

    @GetMapping(value={"", "/"})
    @ApiOperation(value="\u5217\u8868", position=10, notes="\u5206\u9875\u67e5\u8be2\u6587\u4ef6", produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="current", value="\u9875\u7801", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="searchKey", value="\u67e5\u8be2\u6761\u4ef6", paramType="query", dataType="string")})
    public R<PageVO<SysFileVO>> getPage(@ApiParam(name="\u67e5\u8be2", value="\u4f20\u5165\u67e5\u8be2\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) FileSearchDTO searchDTO) {
        PageVO<DashboardFileEntity> page = this.fileService.getPage(searchDTO);
        PageVO pageVO = BeanConvertUtils.convertPage(page, SysFileVO.class);
        return R.success((Object)pageVO);
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20", notes="\u4e0a\u4f20", produces="application/json")
    public R<DashboardFileEntity> upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="module", required=false) String module, HttpServletResponse response, HttpServletRequest request) {
        DashboardFileEntity entity = new DashboardFileEntity();
        if (StringUtils.isBlank((CharSequence)module)) {
            module = "other";
        }
        entity.setModule(module);
        this.sysOssService.upload(file, entity, response, request);
        this.fileService.save(entity);
        return R.success((Object)entity);
    }

    @PostMapping(value={"/download/{id}"})
    @ApiOperation(value="\u4e0b\u8f7d", notes="\u4e0b\u8f7d\u8d44\u6e90", produces="application/x-www-form-urlencoded")
    public void download(@PathVariable(value="id") String id, HttpServletResponse response, HttpServletRequest request) {
        this.sysOssService.download(id, response, request);
    }

    @GetMapping(value={"/getAllFileSuffix"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6587\u4ef6\u540e\u7f00\u540d", notes="\u83b7\u53d6\u6240\u6709\u6587\u4ef6\u540e\u7f00\u540d", produces="application/x-www-form-urlencoded")
    public R<List<String>> getAllFileSuffix() {
        List<String> extensions = this.fileService.getAllExtension();
        extensions.remove("");
        return R.success(extensions);
    }

    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664", produces="application/x-www-form-urlencoded")
    public R<Boolean> delete(@PathVariable(value="id") String id) {
        this.sysOssService.delete(id);
        return R.success((Object)true);
    }
}

