/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.chart.service;

import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.JSON;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dashboard.core.module.chart.bean.Chart;
import com.gccloud.dashboard.core.module.chart.bean.Filter;
import com.gccloud.dashboard.core.module.chart.components.datasource.BaseChartDataSource;
import com.gccloud.dashboard.core.module.chart.components.datasource.DataSetDataSource;
import com.gccloud.dashboard.core.module.chart.dto.ChartDataSearchDTO;
import com.gccloud.dashboard.core.module.chart.vo.ChartDataVO;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.config.JsonDataSetConfig;
import com.gccloud.dataset.params.ParamsClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.factory.DataSetServiceFactory;
import com.gccloud.dataset.vo.DatasetInfoVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="dashboardBaseChartDataService")
public class BaseChartDataService {
    private static final Logger log = LoggerFactory.getLogger(BaseChartDataService.class);
    @Resource
    private DataSetServiceFactory dataSetServiceFactory;
    @Resource
    private ParamsClient paramsClient;

    public ChartDataVO dataQuery(Chart chart, ChartDataSearchDTO searchDTO) {
        BaseChartDataSource dataSource = chart.getDataSource();
        if (dataSource == null) {
            return null;
        }
        if (!dataSource.getClass().equals(DataSetDataSource.class)) {
            return null;
        }
        DataSetDataSource dataSetDataSource = (DataSetDataSource)dataSource;
        if (StringUtils.isBlank((CharSequence)dataSetDataSource.getBusinessKey())) {
            return null;
        }
        IBaseDataSetService dataSetService = this.dataSetServiceFactory.buildById(dataSetDataSource.getBusinessKey());
        DatasetEntity datasetEntity = dataSetService.getByIdFromCache(dataSetDataSource.getBusinessKey());
        if (datasetEntity == null) {
            return null;
        }
        if ("json".equals(datasetEntity.getDatasetType())) {
            return this.jsonDataQuery(datasetEntity, dataSetDataSource, dataSetService);
        }
        return this.dataSetDataQuery(dataSetDataSource, chart, searchDTO, dataSetService);
    }

    private ChartDataVO jsonDataQuery(DatasetEntity dataSet, DataSetDataSource dataSetDataSource, IBaseDataSetService dataSetService) {
        ChartDataVO dataDTO = new ChartDataVO();
        JsonDataSetConfig config = (JsonDataSetConfig)dataSet.getConfig();
        Object jsonContent = dataSetService.execute(dataSet.getId(), null);
        ArrayList data = Lists.newArrayList();
        if (jsonContent instanceof JSONArray) {
            jsonContent = ((JSONArray)jsonContent).toList();
        }
        if (jsonContent instanceof ArrayList) {
            ArrayList list = (ArrayList)jsonContent;
            for (Object o : list) {
                if (!(o instanceof HashMap)) continue;
                data.add((HashMap)o);
            }
        }
        if (jsonContent instanceof HashMap) {
            HashMap map = (HashMap)jsonContent;
            data.add(map);
        }
        if (jsonContent instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)jsonContent;
            data.add(jsonObject.toMap());
        }
        HashMap columnData = Maps.newHashMap();
        Map fieldDesc = config.getFieldDesc();
        fieldDesc.forEach((k, v) -> {
            ChartDataVO.ColumnData column = new ChartDataVO.ColumnData();
            column.setOriginalColumn((String)k);
            column.setAlias((String)k);
            column.setRemark(v.toString());
            columnData.put(k, column);
        });
        dataDTO.setData(data);
        dataDTO.setSuccess(true);
        dataDTO.setColumnData(columnData);
        return dataDTO;
    }

    private ChartDataVO dataSetDataQuery(DataSetDataSource dataSource, Chart chart, ChartDataSearchDTO searchDTO, IBaseDataSetService dataSetService) {
        Object data;
        List setParams;
        ChartDataVO dataDTO = new ChartDataVO();
        List<DatasetParamDTO> params = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)dataSource.getBusinessKey())) {
            throw new GlobalException("\u56fe\u8868\u672a\u914d\u7f6e\u6570\u636e\u96c6");
        }
        DatasetInfoVO dataSetInfoVo = dataSetService.getInfoById(dataSource.getBusinessKey());
        HashMap columnData = Maps.newHashMap();
        List fieldJson = dataSetInfoVo.getFields();
        for (Map field : fieldJson) {
            ChartDataVO.ColumnData column = new ChartDataVO.ColumnData();
            column.setOriginalColumn(field.get("fieldName").toString());
            column.setAlias(field.get("fieldName").toString());
            column.setRemark(field.get("fieldDesc").toString());
            String sourceTable = field.get("sourceTable") == null ? "" : field.get("sourceTable").toString();
            column.setTableName(sourceTable);
            String type = field.get("fieldType") == null ? "" : field.get("fieldType").toString();
            column.setType(type);
            columnData.put(field.get("fieldName").toString(), column);
        }
        if (chart.getType().equals("tables")) {
            List<String> dimensionFieldList = dataSource.getDimensionFieldList();
            LinkedHashMap newColumnData = Maps.newLinkedHashMap();
            dimensionFieldList.forEach(dimensionField -> {
                ChartDataVO.ColumnData cfr_ignored_0 = (ChartDataVO.ColumnData)newColumnData.put(dimensionField, columnData.get(dimensionField));
            });
            columnData.forEach((key, value) -> {
                if (!newColumnData.containsKey(key)) {
                    newColumnData.put(key, value);
                }
            });
        }
        if (dataSource.getParams() != null && dataSource.getParams().size() > 0) {
            setParams = dataSetInfoVo.getParams();
            for (DatasetParamDTO param : setParams) {
                if (!dataSource.getParams().containsKey(param.getName())) continue;
                String value2 = dataSource.getParams().get(param.getName()).toString();
                if (searchDTO.getFilterList() != null && searchDTO.getFilterList().size() > 0) {
                    for (Filter filter : searchDTO.getFilterList()) {
                        if (filter.getColumn() == null || !filter.getColumn().equals(param.getName()) || filter.getValue() == null || filter.getValue().size() == 0) continue;
                        value2 = filter.getValue().get(0);
                        break;
                    }
                }
                param.setValue(value2);
                param.setStatus(Integer.valueOf(1));
                params.add(param);
            }
        } else {
            setParams = dataSetInfoVo.getParams();
            if (setParams == null) {
                setParams = Lists.newArrayList();
            }
            params = setParams;
        }
        dataDTO.setColumnData(columnData);
        log.info("\u67e5\u8be2\u6570\u636e\u96c6\u6570\u636e\uff0c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)params));
        if (dataSource.getServerPagination() != null && dataSource.getServerPagination().booleanValue() && searchDTO.getSize() != null && searchDTO.getCurrent() != null) {
            PageVO pageResult = dataSetService.execute(dataSource.getBusinessKey(), (List)params, searchDTO.getCurrent().intValue(), searchDTO.getSize().intValue());
            data = pageResult.getList();
            dataDTO.setTotalCount((int)pageResult.getTotalCount());
            dataDTO.setTotalPage((int)pageResult.getTotalPage());
        } else {
            data = dataSetService.execute(dataSource.getBusinessKey(), (List)params);
        }
        boolean backendExecutionNeeded = dataSetService.checkBackendExecutionNeeded(dataSource.getBusinessKey());
        dataDTO.setExecutionByFrontend(!backendExecutionNeeded);
        dataDTO.setData(data);
        dataDTO.setSuccess(true);
        return dataDTO;
    }
}

