/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.sub.client;

import com.envisioniot.sub.client.BaseService;
import com.envisioniot.sub.client.advancedalert.IAdvancedAlertService;
import com.envisioniot.sub.client.caseevent.IEventService;
import com.envisioniot.sub.client.data.IDataService;
import com.envisioniot.sub.client.event.IAlertService;
import com.envisioniot.sub.client.newdata.INewDataService;
import com.envisioniot.sub.client.report.IReportService;
import com.envisioniot.sub.common.model.SubCategory;
import java.util.Iterator;
import java.util.ServiceLoader;

public class EosClient {
    private String host;
    private int port;
    private String accessKey;
    private String accessSecret;
    private int requestTimeout = 0;
    private boolean isGlobalBatch = false;
    private boolean isEdge = false;
    private Object[] ops;
    static String ENOS_CLIENT_IMPL = "com.envisioniot.sub.client";

    public EosClient(String host, int port, String accessKey, String accessSecret) {
        this.host = host;
        this.port = port;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
    }

    public EosClient(boolean globalBatch, String host, int port, String accessKey, String accessSecret) {
        this.host = host;
        this.port = port;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.isGlobalBatch = globalBatch;
    }

    public EosClient(String host, int port, String accessKey, String accessSecret, boolean isEdge, Object ... ops) {
        this.host = host;
        this.port = port;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.isEdge = isEdge;
        this.ops = ops;
    }

    public IAlertService getAlertService() {
        return this.getAlertService(this.isGlobalBatch);
    }

    public IAlertService getAlertService(boolean isBatch) {
        IAlertService service = this.getServiceImpl(IAlertService.class);
        this.config((BaseService)service, SubCategory.EVENT, isBatch);
        return service;
    }

    public IDataService getDataService() {
        return this.getDataService(this.isGlobalBatch);
    }

    public IDataService getDataService(boolean isBatch) {
        IDataService service = this.getServiceImpl(IDataService.class);
        this.config((BaseService)service, SubCategory.DATA, isBatch);
        return service;
    }

    public IDataService getOfflineDataService() {
        return this.getOfflineDataService(this.isGlobalBatch);
    }

    public IDataService getOfflineDataService(boolean isBatch) {
        IDataService service = this.getServiceImpl(IDataService.class);
        this.config((BaseService)service, SubCategory.OFFLINE, isBatch);
        return service;
    }

    public INewDataService getNewDataService() {
        return this.getNewDataService(this.isGlobalBatch);
    }

    public INewDataService getNewDataService(boolean isBatch) {
        INewDataService service = this.getServiceImpl(INewDataService.class);
        this.config((BaseService)service, SubCategory.NEW_DATA, isBatch);
        return service;
    }

    public INewDataService getNewOfflineDataService() {
        return this.getNewOfflineDataService(this.isGlobalBatch);
    }

    public INewDataService getNewOfflineDataService(boolean isBatch) {
        INewDataService service = this.getServiceImpl(INewDataService.class);
        this.config((BaseService)service, SubCategory.NEW_OFFLINE, isBatch);
        return service;
    }

    public IEventService getEventService() {
        return this.getEventService(this.isGlobalBatch);
    }

    public IEventService getEventService(boolean isBatch) {
        IEventService service = this.getServiceImpl(IEventService.class);
        this.config((BaseService)service, SubCategory.CASE, isBatch);
        return service;
    }

    public IAdvancedAlertService getAdvancedAlertService() {
        return this.getAdvancedAlertService(this.isGlobalBatch);
    }

    public IAdvancedAlertService getAdvancedAlertService(boolean isBatch) {
        IAdvancedAlertService service = this.getServiceImpl(IAdvancedAlertService.class);
        this.config((BaseService)service, SubCategory.ALERT, isBatch);
        return service;
    }

    public IReportService getReportService() {
        return this.getReportService(this.isGlobalBatch);
    }

    public IReportService getReportService(boolean isBatch) {
        IReportService service = this.getServiceImpl(IReportService.class);
        this.config((BaseService)service, SubCategory.REPORT, isBatch);
        return service;
    }

    public void setRequestTimeout(int timeout) {
        this.requestTimeout = timeout;
    }

    private <S> S getServiceImpl(Class<S> service) {
        String serviceName = service.getSimpleName().substring(1);
        Iterator<S> iterator = ServiceLoader.load(service).iterator();
        int allIndex = 10;
        while (allIndex-- > 0) {
            boolean isEnos;
            S s;
            try {
                s = iterator.next();
            }
            catch (Throwable e) {
                continue;
            }
            String packageName = s.getClass().getPackage().getName();
            String className = s.getClass().getSimpleName();
            boolean bl = isEnos = packageName.contains(ENOS_CLIENT_IMPL) && className.equals(serviceName + "Impl");
            if (!this.isEdge && isEnos) {
                return s;
            }
            if (!this.isEdge || isEnos) continue;
            return s;
        }
        throw new RuntimeException("Not found the interface [I" + serviceName + "] implement.");
    }

    private void config(BaseService service, SubCategory subCategory, boolean isBatch) {
        service.init(subCategory, this.host, this.port, this.accessKey, this.accessSecret, isBatch);
        if (this.requestTimeout > 0) {
            service.setRequestTimeout(this.requestTimeout);
        }
        if (this.ops != null) {
            service.setOptions(this.ops);
        }
    }
}

