/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.asset_tree_service.vo;

import com.envisioniot.enos.asset_tree_service.vo.AssetVo;
import com.envisioniot.enos.asset_tree_service.vo.PageVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class AssetPathListVo
implements Serializable {
    private final PageVo pagination;
    private final List<List<String>> assetPathes;
    private final Map<String, AssetVo> assets;

    public List<List<AssetVo>> getDetailedAssetPathes() {
        ArrayList<List<AssetVo>> result = new ArrayList<List<AssetVo>>();
        for (List<String> inner : this.assetPathes) {
            ArrayList<AssetVo> innerList = new ArrayList<AssetVo>();
            for (String assetId : inner) {
                innerList.add(this.assets.get(assetId));
            }
            result.add(innerList);
        }
        return result;
    }

    public AssetPathListVo(PageVo pagination, List<List<String>> assetPathes, Map<String, AssetVo> assets) {
        this.pagination = pagination;
        this.assetPathes = assetPathes;
        this.assets = assets;
    }

    public PageVo getPagination() {
        return this.pagination;
    }

    public List<List<String>> getAssetPathes() {
        return this.assetPathes;
    }

    public Map<String, AssetVo> getAssets() {
        return this.assets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetPathListVo)) {
            return false;
        }
        AssetPathListVo other = (AssetPathListVo)o;
        PageVo this$pagination = this.getPagination();
        PageVo other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination)) {
            return false;
        }
        List<List<String>> this$assetPathes = this.getAssetPathes();
        List<List<String>> other$assetPathes = other.getAssetPathes();
        if (this$assetPathes == null ? other$assetPathes != null : !((Object)this$assetPathes).equals(other$assetPathes)) {
            return false;
        }
        Map<String, AssetVo> this$assets = this.getAssets();
        Map<String, AssetVo> other$assets = other.getAssets();
        return !(this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PageVo $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        List<List<String>> $assetPathes = this.getAssetPathes();
        result = result * 59 + ($assetPathes == null ? 43 : ((Object)$assetPathes).hashCode());
        Map<String, AssetVo> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        return result;
    }

    public String toString() {
        return "AssetPathListVo(pagination=" + this.getPagination() + ", assetPathes=" + this.getAssetPathes() + ", assets=" + this.getAssets() + ")";
    }
}

