package com.envisioniot.enos.model_service.v2_1;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import com.envisioniot.enos.model_service.vo.ThingAttribute;
import com.envisioniot.enos.model_service.vo.ThingEvent;
import com.envisioniot.enos.model_service.vo.ThingMeasurepoint;
import com.envisioniot.enos.model_service.vo.ThingService;
import lombok.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName UpdateThingModelRequest
 * @Description TODO
 * @date 2020/5/19 12:40
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class UpdateThingModelRequest extends AbstractThingModelRequest {
    private Boolean isPatchUpdate = true;

    private List<String> featuresToDelete;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (isPatchUpdate != null) {
            map.put("isPatchUpdate", isPatchUpdate);
        }
        map.putAll(super.queryParams());
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>();
        if (featuresToDelete != null) {
            map.put("featuresToDelete", featuresToDelete);
        }
        map.putAll(super.bodyParams());
        return map;
    }

    /**
     * return action name
     *
     * @return action name
     */
    @Override
    protected String action() {
        return "update";
    }

    /**
     * request 's response class
     *
     * @return
     */
    @Override
    public Class<UpdateThingModelResponse> getResponseClass() {
        return UpdateThingModelResponse.class;
    }
}
