package com.envisioniot.enos.model_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @version v2.1
 * @author hongjie.shan
 * @date 2019/5/25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SearchThingModelRequest  extends PoseidonRequest {
    private String orgId;

    private String expression;

    /**
     * 0: find model from private org only; 1: find model from private and public org
     * default 1
     */
    private Integer scope;

    /**
     * whether return data point definition in json schema
     */
//    private Boolean withSchema;

    private Projection projection;

    private Pagination pagination;

    @Override
    public String baseUri() {
        return "/model-service/v2.1/thing-models";
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public Map<String, String> headerParams() {
        Map<String, String> params = new HashMap<>();
        params.put("response-format-type", "response-format-type");

        return params;
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "search");

        params.put("orgId", orgId);
        params.put("scope", scope);
//        params.put("withSchema", withSchema);

        return params;

    }

    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();

        params.put("expression", expression);
        params.put("projection", projection);
        params.put("pagination", pagination);
        return params;
    }

    public Class<SearchThingModelResponse> getResponseClass() {
        return SearchThingModelResponse.class;
    }
}
