package com.envisioniot.enos.model_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @version v2.1
 * @author hongjie.shan
 * @date 2019/5/25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class GetThingModelRequest  extends PoseidonRequest {
    private String orgId;

    private String modelId;

    /**
     * 0: find model from private org only; 1: find model from private and public org
     * default 1
     */
    private Integer scope;

    /**
     * whether return data point definition in json schema
     */
//    private Boolean withSchema;

    @Override
    public String baseUri() {
        return "/model-service/v2.1/thing-models";
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "get");

        params.put("orgId", orgId);
        params.put("modelId", modelId);
        params.put("scope", scope);
//        params.put("withSchema", withSchema);

        return params;
    }

    public Class<GetThingModelResponse> getResponseClass() {
        return GetThingModelResponse.class;
    }
}
