package com.envisioniot.enos.model_service.v2_1;

import lombok.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName CreateThingModelRequest
 * @Description TODO
 * @date 2020/5/19 12:19
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class CreateThingModelRequest extends AbstractThingModelRequest {
    private String actionType;
    private String fromModelId;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        map.put("actionType", actionType);
        map.putAll(super.queryParams());
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("fromModelId", fromModelId);
        map.putAll(super.bodyParams());
        return map;
    }

    @Override
    public Class<CreateThingModelResponse> getResponseClass() {
        return  CreateThingModelResponse.class;
    }

    /**
     * return action name
     *
     * @return action name
     */
    @Override
    protected String action() {
        return "create";
    }
}
